#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-alert-action-email.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.AlertAction import AlertAction
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class AlertActionEmail(AlertAction):
    """
    *(extends* :py:class:`delphixpy.web.vo.AlertAction` *)* An alert action
    that generates email in some form. This is an abstract type and cannot be
    instantiated directly.
    """
    def __init__(self, undef_enabled=True):
        super(AlertActionEmail, self).__init__()
        self._type = ("AlertActionEmail", True)
        self._format = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(AlertActionEmail, cls).from_dict(data, dirty, undef_enabled)
        obj._format = (data.get("format", obj.__undef__), dirty)
        if obj._format[0] is not None and obj._format[0] is not obj.__undef__:
            assert isinstance(obj._format[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._format[0]))
            assert obj._format[0] in [u'HTML', u'TEXT', u'JSON'], "Expected enum [u'HTML', u'TEXT', u'JSON'] but got %s" % obj._format[0]
            common.validate_format(obj._format[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(AlertActionEmail, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "format" == "type" or (self.format is not self.__undef__ and (not (dirty and not self._format[1]) or isinstance(self.format, list) or belongs_to_parent)):
            dct["format"] = dictify(self.format)
        elif belongs_to_parent and self.format is self.__undef__:
            dct["format"] = "HTML"
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._format = (self._format[0], True)

    def is_dirty(self):
        return any([self._format[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AlertActionEmail):
            return False
        return super(AlertActionEmail, self).__eq__(other) and \
               self.format == other.format

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def format(self):
        """
        *(default value: HTML)* Email format to use. The HTML format will
        generate a multipart message containing both HTML and plain text. The
        TEXT format will explicitly generate text-only mail. The JSON format
        will generate a JSON object identical to the $Alert format returned
        through the web services API. *(permitted values: HTML, TEXT, JSON)*

        :rtype: ``basestring``
        """
        return self._format[0]

    @format.setter
    def format(self, value):
        self._format = (value, True)

