#
# Copyright 2018 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-timezone.json
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef(object):
    def __repr__(self):
        return "undef"

_UNDEFINED = __Undef()

class TimeZone(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* This represents a
    time zone offset.
    """
    def __init__(self, undef_enabled=True):
        super(TimeZone, self).__init__()
        self._type = ("TimeZone", True)
        self._id = (self.__undef__, True)
        self._offset_string = (self.__undef__, True)
        self._offset = (self.__undef__, True)

    API_VERSION = "1.10.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(TimeZone, cls).from_dict(data, dirty, undef_enabled)
        if "id" not in data:
            raise ValueError("Missing required property \"id\".")
        obj._id = (data.get("id", obj.__undef__), dirty)
        if obj._id[0] is not None and obj._id[0] is not obj.__undef__:
            assert isinstance(obj._id[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._id[0]))
            assert obj._id[0] in [u'ACT', u'AET', u'AGT', u'ART', u'AST', u'Africa/Abidjan', u'Africa/Accra', u'Africa/Addis_Ababa', u'Africa/Algiers', u'Africa/Asmara', u'Africa/Asmera', u'Africa/Bamako', u'Africa/Bangui', u'Africa/Banjul', u'Africa/Bissau', u'Africa/Blantyre', u'Africa/Brazzaville', u'Africa/Bujumbura', u'Africa/Cairo', u'Africa/Casablanca', u'Africa/Ceuta', u'Africa/Conakry', u'Africa/Dakar', u'Africa/Dar_es_Salaam', u'Africa/Djibouti', u'Africa/Douala', u'Africa/El_Aaiun', u'Africa/Freetown', u'Africa/Gaborone', u'Africa/Harare', u'Africa/Johannesburg', u'Africa/Juba', u'Africa/Kampala', u'Africa/Khartoum', u'Africa/Kigali', u'Africa/Kinshasa', u'Africa/Lagos', u'Africa/Libreville', u'Africa/Lome', u'Africa/Luanda', u'Africa/Lubumbashi', u'Africa/Lusaka', u'Africa/Malabo', u'Africa/Maputo', u'Africa/Maseru', u'Africa/Mbabane', u'Africa/Mogadishu', u'Africa/Monrovia', u'Africa/Nairobi', u'Africa/Ndjamena', u'Africa/Niamey', u'Africa/Nouakchott', u'Africa/Ouagadougou', u'Africa/Porto-Novo', u'Africa/Sao_Tome', u'Africa/Timbuktu', u'Africa/Tripoli', u'Africa/Tunis', u'Africa/Windhoek', u'America/Adak', u'America/Anchorage', u'America/Anguilla', u'America/Antigua', u'America/Araguaina', u'America/Argentina/Buenos_Aires', u'America/Argentina/Catamarca', u'America/Argentina/ComodRivadavia', u'America/Argentina/Cordoba', u'America/Argentina/Jujuy', u'America/Argentina/La_Rioja', u'America/Argentina/Mendoza', u'America/Argentina/Rio_Gallegos', u'America/Argentina/Salta', u'America/Argentina/San_Juan', u'America/Argentina/San_Luis', u'America/Argentina/Tucuman', u'America/Argentina/Ushuaia', u'America/Aruba', u'America/Asuncion', u'America/Atikokan', u'America/Atka', u'America/Bahia', u'America/Bahia_Banderas', u'America/Barbados', u'America/Belem', u'America/Belize', u'America/Blanc-Sablon', u'America/Boa_Vista', u'America/Bogota', u'America/Boise', u'America/Buenos_Aires', u'America/Cambridge_Bay', u'America/Campo_Grande', u'America/Cancun', u'America/Caracas', u'America/Catamarca', u'America/Cayenne', u'America/Cayman', u'America/Chicago', u'America/Chihuahua', u'America/Coral_Harbour', u'America/Cordoba', u'America/Costa_Rica', u'America/Creston', u'America/Cuiaba', u'America/Curacao', u'America/Danmarkshavn', u'America/Dawson', u'America/Dawson_Creek', u'America/Denver', u'America/Detroit', u'America/Dominica', u'America/Edmonton', u'America/Eirunepe', u'America/El_Salvador', u'America/Ensenada', u'America/Fort_Nelson', u'America/Fort_Wayne', u'America/Fortaleza', u'America/Glace_Bay', u'America/Godthab', u'America/Goose_Bay', u'America/Grand_Turk', u'America/Grenada', u'America/Guadeloupe', u'America/Guatemala', u'America/Guayaquil', u'America/Guyana', u'America/Halifax', u'America/Havana', u'America/Hermosillo', u'America/Indiana/Indianapolis', u'America/Indiana/Knox', u'America/Indiana/Marengo', u'America/Indiana/Petersburg', u'America/Indiana/Tell_City', u'America/Indiana/Vevay', u'America/Indiana/Vincennes', u'America/Indiana/Winamac', u'America/Indianapolis', u'America/Inuvik', u'America/Iqaluit', u'America/Jamaica', u'America/Jujuy', u'America/Juneau', u'America/Kentucky/Louisville', u'America/Kentucky/Monticello', u'America/Knox_IN', u'America/Kralendijk', u'America/La_Paz', u'America/Lima', u'America/Los_Angeles', u'America/Louisville', u'America/Lower_Princes', u'America/Maceio', u'America/Managua', u'America/Manaus', u'America/Marigot', u'America/Martinique', u'America/Matamoros', u'America/Mazatlan', u'America/Mendoza', u'America/Menominee', u'America/Merida', u'America/Metlakatla', u'America/Mexico_City', u'America/Miquelon', u'America/Moncton', u'America/Monterrey', u'America/Montevideo', u'America/Montreal', u'America/Montserrat', u'America/Nassau', u'America/New_York', u'America/Nipigon', u'America/Nome', u'America/Noronha', u'America/North_Dakota/Beulah', u'America/North_Dakota/Center', u'America/North_Dakota/New_Salem', u'America/Ojinaga', u'America/Panama', u'America/Pangnirtung', u'America/Paramaribo', u'America/Phoenix', u'America/Port-au-Prince', u'America/Port_of_Spain', u'America/Porto_Acre', u'America/Porto_Velho', u'America/Puerto_Rico', u'America/Punta_Arenas', u'America/Rainy_River', u'America/Rankin_Inlet', u'America/Recife', u'America/Regina', u'America/Resolute', u'America/Rio_Branco', u'America/Rosario', u'America/Santa_Isabel', u'America/Santarem', u'America/Santiago', u'America/Santo_Domingo', u'America/Sao_Paulo', u'America/Scoresbysund', u'America/Shiprock', u'America/Sitka', u'America/St_Barthelemy', u'America/St_Johns', u'America/St_Kitts', u'America/St_Lucia', u'America/St_Thomas', u'America/St_Vincent', u'America/Swift_Current', u'America/Tegucigalpa', u'America/Thule', u'America/Thunder_Bay', u'America/Tijuana', u'America/Toronto', u'America/Tortola', u'America/Vancouver', u'America/Virgin', u'America/Whitehorse', u'America/Winnipeg', u'America/Yakutat', u'America/Yellowknife', u'Antarctica/Casey', u'Antarctica/Davis', u'Antarctica/DumontDUrville', u'Antarctica/Macquarie', u'Antarctica/Mawson', u'Antarctica/McMurdo', u'Antarctica/Palmer', u'Antarctica/Rothera', u'Antarctica/South_Pole', u'Antarctica/Syowa', u'Antarctica/Troll', u'Antarctica/Vostok', u'Arctic/Longyearbyen', u'Asia/Aden', u'Asia/Almaty', u'Asia/Amman', u'Asia/Anadyr', u'Asia/Aqtau', u'Asia/Aqtobe', u'Asia/Ashgabat', u'Asia/Ashkhabad', u'Asia/Atyrau', u'Asia/Baghdad', u'Asia/Bahrain', u'Asia/Baku', u'Asia/Bangkok', u'Asia/Barnaul', u'Asia/Beirut', u'Asia/Bishkek', u'Asia/Brunei', u'Asia/Calcutta', u'Asia/Chita', u'Asia/Choibalsan', u'Asia/Chongqing', u'Asia/Chungking', u'Asia/Colombo', u'Asia/Dacca', u'Asia/Damascus', u'Asia/Dhaka', u'Asia/Dili', u'Asia/Dubai', u'Asia/Dushanbe', u'Asia/Famagusta', u'Asia/Gaza', u'Asia/Harbin', u'Asia/Hebron', u'Asia/Ho_Chi_Minh', u'Asia/Hong_Kong', u'Asia/Hovd', u'Asia/Irkutsk', u'Asia/Istanbul', u'Asia/Jakarta', u'Asia/Jayapura', u'Asia/Jerusalem', u'Asia/Kabul', u'Asia/Kamchatka', u'Asia/Karachi', u'Asia/Kashgar', u'Asia/Kathmandu', u'Asia/Katmandu', u'Asia/Khandyga', u'Asia/Kolkata', u'Asia/Krasnoyarsk', u'Asia/Kuala_Lumpur', u'Asia/Kuching', u'Asia/Kuwait', u'Asia/Macao', u'Asia/Macau', u'Asia/Magadan', u'Asia/Makassar', u'Asia/Manila', u'Asia/Muscat', u'Asia/Nicosia', u'Asia/Novokuznetsk', u'Asia/Novosibirsk', u'Asia/Omsk', u'Asia/Oral', u'Asia/Phnom_Penh', u'Asia/Pontianak', u'Asia/Pyongyang', u'Asia/Qatar', u'Asia/Qyzylorda', u'Asia/Rangoon', u'Asia/Riyadh', u'Asia/Saigon', u'Asia/Sakhalin', u'Asia/Samarkand', u'Asia/Seoul', u'Asia/Shanghai', u'Asia/Singapore', u'Asia/Srednekolymsk', u'Asia/Taipei', u'Asia/Tashkent', u'Asia/Tbilisi', u'Asia/Tehran', u'Asia/Tel_Aviv', u'Asia/Thimbu', u'Asia/Thimphu', u'Asia/Tomsk', u'Asia/Tokyo', u'Asia/Ujung_Pandang', u'Asia/Ulaanbaatar', u'Asia/Ulan_Bator', u'Asia/Urumqi', u'Asia/Ust-Nera', u'Asia/Vientiane', u'Asia/Vladivostok', u'Asia/Yakutsk', u'Asia/Yangon', u'Asia/Yekaterinburg', u'Asia/Yerevan', u'Atlantic/Azores', u'Atlantic/Bermuda', u'Atlantic/Canary', u'Atlantic/Cape_Verde', u'Atlantic/Faeroe', u'Atlantic/Faroe', u'Atlantic/Jan_Mayen', u'Atlantic/Madeira', u'Atlantic/Reykjavik', u'Atlantic/South_Georgia', u'Atlantic/St_Helena', u'Atlantic/Stanley', u'Australia/ACT', u'Australia/Adelaide', u'Australia/Brisbane', u'Australia/Broken_Hill', u'Australia/Canberra', u'Australia/Currie', u'Australia/Darwin', u'Australia/Eucla', u'Australia/Hobart', u'Australia/LHI', u'Australia/Lindeman', u'Australia/Lord_Howe', u'Australia/Melbourne', u'Australia/NSW', u'Australia/North', u'Australia/Perth', u'Australia/Queensland', u'Australia/South', u'Australia/Sydney', u'Australia/Tasmania', u'Australia/Victoria', u'Australia/West', u'Australia/Yancowinna', u'BET', u'BST', u'Brazil/Acre', u'Brazil/DeNoronha', u'Brazil/East', u'Brazil/West', u'CAT', u'CET', u'CNT', u'CST', u'CST6CDT', u'CTT', u'Canada/Atlantic', u'Canada/Central', u'Canada/Eastern', u'Canada/Mountain', u'Canada/Newfoundland', u'Canada/Pacific', u'Canada/Saskatchewan', u'Canada/Yukon', u'Chile/Continental', u'Chile/EasterIsland', u'Cuba', u'EAT', u'ECT', u'EET', u'EST', u'EST5EDT', u'Egypt', u'Eire', u'Etc/GMT', u'Etc/GMT+0', u'Etc/GMT+1', u'Etc/GMT+10', u'Etc/GMT+11', u'Etc/GMT+12', u'Etc/GMT+2', u'Etc/GMT+3', u'Etc/GMT+4', u'Etc/GMT+5', u'Etc/GMT+6', u'Etc/GMT+7', u'Etc/GMT+8', u'Etc/GMT+9', u'Etc/GMT-0', u'Etc/GMT-1', u'Etc/GMT-10', u'Etc/GMT-11', u'Etc/GMT-12', u'Etc/GMT-13', u'Etc/GMT-14', u'Etc/GMT-2', u'Etc/GMT-3', u'Etc/GMT-4', u'Etc/GMT-5', u'Etc/GMT-6', u'Etc/GMT-7', u'Etc/GMT-8', u'Etc/GMT-9', u'Etc/GMT0', u'Etc/Greenwich', u'Etc/UCT', u'Etc/UTC', u'Etc/Universal', u'Etc/Zulu', u'Europe/Amsterdam', u'Europe/Andorra', u'Europe/Astrakhan', u'Europe/Athens', u'Europe/Belfast', u'Europe/Belgrade', u'Europe/Berlin', u'Europe/Bratislava', u'Europe/Brussels', u'Europe/Bucharest', u'Europe/Budapest', u'Europe/Busingen', u'Europe/Chisinau', u'Europe/Copenhagen', u'Europe/Dublin', u'Europe/Gibraltar', u'Europe/Guernsey', u'Europe/Helsinki', u'Europe/Isle_of_Man', u'Europe/Istanbul', u'Europe/Jersey', u'Europe/Kaliningrad', u'Europe/Kiev', u'Europe/Kirov', u'Europe/Lisbon', u'Europe/Ljubljana', u'Europe/London', u'Europe/Luxembourg', u'Europe/Madrid', u'Europe/Malta', u'Europe/Mariehamn', u'Europe/Minsk', u'Europe/Monaco', u'Europe/Moscow', u'Europe/Nicosia', u'Europe/Oslo', u'Europe/Paris', u'Europe/Podgorica', u'Europe/Prague', u'Europe/Riga', u'Europe/Rome', u'Europe/Samara', u'Europe/San_Marino', u'Europe/Sarajevo', u'Europe/Saratov', u'Europe/Simferopol', u'Europe/Skopje', u'Europe/Sofia', u'Europe/Stockholm', u'Europe/Tallinn', u'Europe/Tirane', u'Europe/Tiraspol', u'Europe/Ulyanovsk', u'Europe/Uzhgorod', u'Europe/Vaduz', u'Europe/Vatican', u'Europe/Vienna', u'Europe/Vilnius', u'Europe/Volgograd', u'Europe/Warsaw', u'Europe/Zagreb', u'Europe/Zaporozhye', u'Europe/Zurich', u'GB', u'GB-Eire', u'GMT', u'GMT0', u'Greenwich', u'HST', u'Hongkong', u'IET', u'IST', u'Iceland', u'Indian/Antananarivo', u'Indian/Chagos', u'Indian/Christmas', u'Indian/Cocos', u'Indian/Comoro', u'Indian/Kerguelen', u'Indian/Mahe', u'Indian/Maldives', u'Indian/Mauritius', u'Indian/Mayotte', u'Indian/Reunion', u'Iran', u'Israel', u'JST', u'Jamaica', u'Japan', u'Kwajalein', u'Libya', u'MET', u'MIT', u'MST', u'MST7MDT', u'Mexico/BajaNorte', u'Mexico/BajaSur', u'Mexico/General', u'NET', u'NST', u'NZ', u'NZ-CHAT', u'Navajo', u'PLT', u'PNT', u'PRC', u'PRT', u'PST', u'PST8PDT', u'Pacific/Apia', u'Pacific/Auckland', u'Pacific/Bougainville', u'Pacific/Chatham', u'Pacific/Chuuk', u'Pacific/Easter', u'Pacific/Efate', u'Pacific/Enderbury', u'Pacific/Fakaofo', u'Pacific/Fiji', u'Pacific/Funafuti', u'Pacific/Galapagos', u'Pacific/Gambier', u'Pacific/Guadalcanal', u'Pacific/Guam', u'Pacific/Honolulu', u'Pacific/Johnston', u'Pacific/Kiritimati', u'Pacific/Kosrae', u'Pacific/Kwajalein', u'Pacific/Majuro', u'Pacific/Marquesas', u'Pacific/Midway', u'Pacific/Nauru', u'Pacific/Niue', u'Pacific/Norfolk', u'Pacific/Noumea', u'Pacific/Pago_Pago', u'Pacific/Palau', u'Pacific/Pitcairn', u'Pacific/Pohnpei', u'Pacific/Ponape', u'Pacific/Port_Moresby', u'Pacific/Rarotonga', u'Pacific/Saipan', u'Pacific/Samoa', u'Pacific/Tahiti', u'Pacific/Tarawa', u'Pacific/Tongatapu', u'Pacific/Truk', u'Pacific/Wake', u'Pacific/Wallis', u'Pacific/Yap', u'Poland', u'Portugal', u'ROK', u'SST', u'Singapore', u'SystemV/AST4', u'SystemV/AST4ADT', u'SystemV/CST6', u'SystemV/CST6CDT', u'SystemV/EST5', u'SystemV/EST5EDT', u'SystemV/HST10', u'SystemV/MST7', u'SystemV/MST7MDT', u'SystemV/PST8', u'SystemV/PST8PDT', u'SystemV/YST9', u'SystemV/YST9YDT', u'Turkey', u'UCT', u'US/Alaska', u'US/Aleutian', u'US/Arizona', u'US/Central', u'US/East-Indiana', u'US/Eastern', u'US/Hawaii', u'US/Indiana-Starke', u'US/Michigan', u'US/Mountain', u'US/Pacific', u'US/Pacific-New', u'US/Samoa', u'UTC', u'Universal', u'VST', u'W-SU', u'WET', u'Zulu'], "Expected enum [u'ACT', u'AET', u'AGT', u'ART', u'AST', u'Africa/Abidjan', u'Africa/Accra', u'Africa/Addis_Ababa', u'Africa/Algiers', u'Africa/Asmara', u'Africa/Asmera', u'Africa/Bamako', u'Africa/Bangui', u'Africa/Banjul', u'Africa/Bissau', u'Africa/Blantyre', u'Africa/Brazzaville', u'Africa/Bujumbura', u'Africa/Cairo', u'Africa/Casablanca', u'Africa/Ceuta', u'Africa/Conakry', u'Africa/Dakar', u'Africa/Dar_es_Salaam', u'Africa/Djibouti', u'Africa/Douala', u'Africa/El_Aaiun', u'Africa/Freetown', u'Africa/Gaborone', u'Africa/Harare', u'Africa/Johannesburg', u'Africa/Juba', u'Africa/Kampala', u'Africa/Khartoum', u'Africa/Kigali', u'Africa/Kinshasa', u'Africa/Lagos', u'Africa/Libreville', u'Africa/Lome', u'Africa/Luanda', u'Africa/Lubumbashi', u'Africa/Lusaka', u'Africa/Malabo', u'Africa/Maputo', u'Africa/Maseru', u'Africa/Mbabane', u'Africa/Mogadishu', u'Africa/Monrovia', u'Africa/Nairobi', u'Africa/Ndjamena', u'Africa/Niamey', u'Africa/Nouakchott', u'Africa/Ouagadougou', u'Africa/Porto-Novo', u'Africa/Sao_Tome', u'Africa/Timbuktu', u'Africa/Tripoli', u'Africa/Tunis', u'Africa/Windhoek', u'America/Adak', u'America/Anchorage', u'America/Anguilla', u'America/Antigua', u'America/Araguaina', u'America/Argentina/Buenos_Aires', u'America/Argentina/Catamarca', u'America/Argentina/ComodRivadavia', u'America/Argentina/Cordoba', u'America/Argentina/Jujuy', u'America/Argentina/La_Rioja', u'America/Argentina/Mendoza', u'America/Argentina/Rio_Gallegos', u'America/Argentina/Salta', u'America/Argentina/San_Juan', u'America/Argentina/San_Luis', u'America/Argentina/Tucuman', u'America/Argentina/Ushuaia', u'America/Aruba', u'America/Asuncion', u'America/Atikokan', u'America/Atka', u'America/Bahia', u'America/Bahia_Banderas', u'America/Barbados', u'America/Belem', u'America/Belize', u'America/Blanc-Sablon', u'America/Boa_Vista', u'America/Bogota', u'America/Boise', u'America/Buenos_Aires', u'America/Cambridge_Bay', u'America/Campo_Grande', u'America/Cancun', u'America/Caracas', u'America/Catamarca', u'America/Cayenne', u'America/Cayman', u'America/Chicago', u'America/Chihuahua', u'America/Coral_Harbour', u'America/Cordoba', u'America/Costa_Rica', u'America/Creston', u'America/Cuiaba', u'America/Curacao', u'America/Danmarkshavn', u'America/Dawson', u'America/Dawson_Creek', u'America/Denver', u'America/Detroit', u'America/Dominica', u'America/Edmonton', u'America/Eirunepe', u'America/El_Salvador', u'America/Ensenada', u'America/Fort_Nelson', u'America/Fort_Wayne', u'America/Fortaleza', u'America/Glace_Bay', u'America/Godthab', u'America/Goose_Bay', u'America/Grand_Turk', u'America/Grenada', u'America/Guadeloupe', u'America/Guatemala', u'America/Guayaquil', u'America/Guyana', u'America/Halifax', u'America/Havana', u'America/Hermosillo', u'America/Indiana/Indianapolis', u'America/Indiana/Knox', u'America/Indiana/Marengo', u'America/Indiana/Petersburg', u'America/Indiana/Tell_City', u'America/Indiana/Vevay', u'America/Indiana/Vincennes', u'America/Indiana/Winamac', u'America/Indianapolis', u'America/Inuvik', u'America/Iqaluit', u'America/Jamaica', u'America/Jujuy', u'America/Juneau', u'America/Kentucky/Louisville', u'America/Kentucky/Monticello', u'America/Knox_IN', u'America/Kralendijk', u'America/La_Paz', u'America/Lima', u'America/Los_Angeles', u'America/Louisville', u'America/Lower_Princes', u'America/Maceio', u'America/Managua', u'America/Manaus', u'America/Marigot', u'America/Martinique', u'America/Matamoros', u'America/Mazatlan', u'America/Mendoza', u'America/Menominee', u'America/Merida', u'America/Metlakatla', u'America/Mexico_City', u'America/Miquelon', u'America/Moncton', u'America/Monterrey', u'America/Montevideo', u'America/Montreal', u'America/Montserrat', u'America/Nassau', u'America/New_York', u'America/Nipigon', u'America/Nome', u'America/Noronha', u'America/North_Dakota/Beulah', u'America/North_Dakota/Center', u'America/North_Dakota/New_Salem', u'America/Ojinaga', u'America/Panama', u'America/Pangnirtung', u'America/Paramaribo', u'America/Phoenix', u'America/Port-au-Prince', u'America/Port_of_Spain', u'America/Porto_Acre', u'America/Porto_Velho', u'America/Puerto_Rico', u'America/Punta_Arenas', u'America/Rainy_River', u'America/Rankin_Inlet', u'America/Recife', u'America/Regina', u'America/Resolute', u'America/Rio_Branco', u'America/Rosario', u'America/Santa_Isabel', u'America/Santarem', u'America/Santiago', u'America/Santo_Domingo', u'America/Sao_Paulo', u'America/Scoresbysund', u'America/Shiprock', u'America/Sitka', u'America/St_Barthelemy', u'America/St_Johns', u'America/St_Kitts', u'America/St_Lucia', u'America/St_Thomas', u'America/St_Vincent', u'America/Swift_Current', u'America/Tegucigalpa', u'America/Thule', u'America/Thunder_Bay', u'America/Tijuana', u'America/Toronto', u'America/Tortola', u'America/Vancouver', u'America/Virgin', u'America/Whitehorse', u'America/Winnipeg', u'America/Yakutat', u'America/Yellowknife', u'Antarctica/Casey', u'Antarctica/Davis', u'Antarctica/DumontDUrville', u'Antarctica/Macquarie', u'Antarctica/Mawson', u'Antarctica/McMurdo', u'Antarctica/Palmer', u'Antarctica/Rothera', u'Antarctica/South_Pole', u'Antarctica/Syowa', u'Antarctica/Troll', u'Antarctica/Vostok', u'Arctic/Longyearbyen', u'Asia/Aden', u'Asia/Almaty', u'Asia/Amman', u'Asia/Anadyr', u'Asia/Aqtau', u'Asia/Aqtobe', u'Asia/Ashgabat', u'Asia/Ashkhabad', u'Asia/Atyrau', u'Asia/Baghdad', u'Asia/Bahrain', u'Asia/Baku', u'Asia/Bangkok', u'Asia/Barnaul', u'Asia/Beirut', u'Asia/Bishkek', u'Asia/Brunei', u'Asia/Calcutta', u'Asia/Chita', u'Asia/Choibalsan', u'Asia/Chongqing', u'Asia/Chungking', u'Asia/Colombo', u'Asia/Dacca', u'Asia/Damascus', u'Asia/Dhaka', u'Asia/Dili', u'Asia/Dubai', u'Asia/Dushanbe', u'Asia/Famagusta', u'Asia/Gaza', u'Asia/Harbin', u'Asia/Hebron', u'Asia/Ho_Chi_Minh', u'Asia/Hong_Kong', u'Asia/Hovd', u'Asia/Irkutsk', u'Asia/Istanbul', u'Asia/Jakarta', u'Asia/Jayapura', u'Asia/Jerusalem', u'Asia/Kabul', u'Asia/Kamchatka', u'Asia/Karachi', u'Asia/Kashgar', u'Asia/Kathmandu', u'Asia/Katmandu', u'Asia/Khandyga', u'Asia/Kolkata', u'Asia/Krasnoyarsk', u'Asia/Kuala_Lumpur', u'Asia/Kuching', u'Asia/Kuwait', u'Asia/Macao', u'Asia/Macau', u'Asia/Magadan', u'Asia/Makassar', u'Asia/Manila', u'Asia/Muscat', u'Asia/Nicosia', u'Asia/Novokuznetsk', u'Asia/Novosibirsk', u'Asia/Omsk', u'Asia/Oral', u'Asia/Phnom_Penh', u'Asia/Pontianak', u'Asia/Pyongyang', u'Asia/Qatar', u'Asia/Qyzylorda', u'Asia/Rangoon', u'Asia/Riyadh', u'Asia/Saigon', u'Asia/Sakhalin', u'Asia/Samarkand', u'Asia/Seoul', u'Asia/Shanghai', u'Asia/Singapore', u'Asia/Srednekolymsk', u'Asia/Taipei', u'Asia/Tashkent', u'Asia/Tbilisi', u'Asia/Tehran', u'Asia/Tel_Aviv', u'Asia/Thimbu', u'Asia/Thimphu', u'Asia/Tomsk', u'Asia/Tokyo', u'Asia/Ujung_Pandang', u'Asia/Ulaanbaatar', u'Asia/Ulan_Bator', u'Asia/Urumqi', u'Asia/Ust-Nera', u'Asia/Vientiane', u'Asia/Vladivostok', u'Asia/Yakutsk', u'Asia/Yangon', u'Asia/Yekaterinburg', u'Asia/Yerevan', u'Atlantic/Azores', u'Atlantic/Bermuda', u'Atlantic/Canary', u'Atlantic/Cape_Verde', u'Atlantic/Faeroe', u'Atlantic/Faroe', u'Atlantic/Jan_Mayen', u'Atlantic/Madeira', u'Atlantic/Reykjavik', u'Atlantic/South_Georgia', u'Atlantic/St_Helena', u'Atlantic/Stanley', u'Australia/ACT', u'Australia/Adelaide', u'Australia/Brisbane', u'Australia/Broken_Hill', u'Australia/Canberra', u'Australia/Currie', u'Australia/Darwin', u'Australia/Eucla', u'Australia/Hobart', u'Australia/LHI', u'Australia/Lindeman', u'Australia/Lord_Howe', u'Australia/Melbourne', u'Australia/NSW', u'Australia/North', u'Australia/Perth', u'Australia/Queensland', u'Australia/South', u'Australia/Sydney', u'Australia/Tasmania', u'Australia/Victoria', u'Australia/West', u'Australia/Yancowinna', u'BET', u'BST', u'Brazil/Acre', u'Brazil/DeNoronha', u'Brazil/East', u'Brazil/West', u'CAT', u'CET', u'CNT', u'CST', u'CST6CDT', u'CTT', u'Canada/Atlantic', u'Canada/Central', u'Canada/Eastern', u'Canada/Mountain', u'Canada/Newfoundland', u'Canada/Pacific', u'Canada/Saskatchewan', u'Canada/Yukon', u'Chile/Continental', u'Chile/EasterIsland', u'Cuba', u'EAT', u'ECT', u'EET', u'EST', u'EST5EDT', u'Egypt', u'Eire', u'Etc/GMT', u'Etc/GMT+0', u'Etc/GMT+1', u'Etc/GMT+10', u'Etc/GMT+11', u'Etc/GMT+12', u'Etc/GMT+2', u'Etc/GMT+3', u'Etc/GMT+4', u'Etc/GMT+5', u'Etc/GMT+6', u'Etc/GMT+7', u'Etc/GMT+8', u'Etc/GMT+9', u'Etc/GMT-0', u'Etc/GMT-1', u'Etc/GMT-10', u'Etc/GMT-11', u'Etc/GMT-12', u'Etc/GMT-13', u'Etc/GMT-14', u'Etc/GMT-2', u'Etc/GMT-3', u'Etc/GMT-4', u'Etc/GMT-5', u'Etc/GMT-6', u'Etc/GMT-7', u'Etc/GMT-8', u'Etc/GMT-9', u'Etc/GMT0', u'Etc/Greenwich', u'Etc/UCT', u'Etc/UTC', u'Etc/Universal', u'Etc/Zulu', u'Europe/Amsterdam', u'Europe/Andorra', u'Europe/Astrakhan', u'Europe/Athens', u'Europe/Belfast', u'Europe/Belgrade', u'Europe/Berlin', u'Europe/Bratislava', u'Europe/Brussels', u'Europe/Bucharest', u'Europe/Budapest', u'Europe/Busingen', u'Europe/Chisinau', u'Europe/Copenhagen', u'Europe/Dublin', u'Europe/Gibraltar', u'Europe/Guernsey', u'Europe/Helsinki', u'Europe/Isle_of_Man', u'Europe/Istanbul', u'Europe/Jersey', u'Europe/Kaliningrad', u'Europe/Kiev', u'Europe/Kirov', u'Europe/Lisbon', u'Europe/Ljubljana', u'Europe/London', u'Europe/Luxembourg', u'Europe/Madrid', u'Europe/Malta', u'Europe/Mariehamn', u'Europe/Minsk', u'Europe/Monaco', u'Europe/Moscow', u'Europe/Nicosia', u'Europe/Oslo', u'Europe/Paris', u'Europe/Podgorica', u'Europe/Prague', u'Europe/Riga', u'Europe/Rome', u'Europe/Samara', u'Europe/San_Marino', u'Europe/Sarajevo', u'Europe/Saratov', u'Europe/Simferopol', u'Europe/Skopje', u'Europe/Sofia', u'Europe/Stockholm', u'Europe/Tallinn', u'Europe/Tirane', u'Europe/Tiraspol', u'Europe/Ulyanovsk', u'Europe/Uzhgorod', u'Europe/Vaduz', u'Europe/Vatican', u'Europe/Vienna', u'Europe/Vilnius', u'Europe/Volgograd', u'Europe/Warsaw', u'Europe/Zagreb', u'Europe/Zaporozhye', u'Europe/Zurich', u'GB', u'GB-Eire', u'GMT', u'GMT0', u'Greenwich', u'HST', u'Hongkong', u'IET', u'IST', u'Iceland', u'Indian/Antananarivo', u'Indian/Chagos', u'Indian/Christmas', u'Indian/Cocos', u'Indian/Comoro', u'Indian/Kerguelen', u'Indian/Mahe', u'Indian/Maldives', u'Indian/Mauritius', u'Indian/Mayotte', u'Indian/Reunion', u'Iran', u'Israel', u'JST', u'Jamaica', u'Japan', u'Kwajalein', u'Libya', u'MET', u'MIT', u'MST', u'MST7MDT', u'Mexico/BajaNorte', u'Mexico/BajaSur', u'Mexico/General', u'NET', u'NST', u'NZ', u'NZ-CHAT', u'Navajo', u'PLT', u'PNT', u'PRC', u'PRT', u'PST', u'PST8PDT', u'Pacific/Apia', u'Pacific/Auckland', u'Pacific/Bougainville', u'Pacific/Chatham', u'Pacific/Chuuk', u'Pacific/Easter', u'Pacific/Efate', u'Pacific/Enderbury', u'Pacific/Fakaofo', u'Pacific/Fiji', u'Pacific/Funafuti', u'Pacific/Galapagos', u'Pacific/Gambier', u'Pacific/Guadalcanal', u'Pacific/Guam', u'Pacific/Honolulu', u'Pacific/Johnston', u'Pacific/Kiritimati', u'Pacific/Kosrae', u'Pacific/Kwajalein', u'Pacific/Majuro', u'Pacific/Marquesas', u'Pacific/Midway', u'Pacific/Nauru', u'Pacific/Niue', u'Pacific/Norfolk', u'Pacific/Noumea', u'Pacific/Pago_Pago', u'Pacific/Palau', u'Pacific/Pitcairn', u'Pacific/Pohnpei', u'Pacific/Ponape', u'Pacific/Port_Moresby', u'Pacific/Rarotonga', u'Pacific/Saipan', u'Pacific/Samoa', u'Pacific/Tahiti', u'Pacific/Tarawa', u'Pacific/Tongatapu', u'Pacific/Truk', u'Pacific/Wake', u'Pacific/Wallis', u'Pacific/Yap', u'Poland', u'Portugal', u'ROK', u'SST', u'Singapore', u'SystemV/AST4', u'SystemV/AST4ADT', u'SystemV/CST6', u'SystemV/CST6CDT', u'SystemV/EST5', u'SystemV/EST5EDT', u'SystemV/HST10', u'SystemV/MST7', u'SystemV/MST7MDT', u'SystemV/PST8', u'SystemV/PST8PDT', u'SystemV/YST9', u'SystemV/YST9YDT', u'Turkey', u'UCT', u'US/Alaska', u'US/Aleutian', u'US/Arizona', u'US/Central', u'US/East-Indiana', u'US/Eastern', u'US/Hawaii', u'US/Indiana-Starke', u'US/Michigan', u'US/Mountain', u'US/Pacific', u'US/Pacific-New', u'US/Samoa', u'UTC', u'Universal', u'VST', u'W-SU', u'WET', u'Zulu'] but got %s" % obj._id[0]
            common.validate_format(obj._id[0], "None", None, None)
        obj._offset_string = (data.get("offsetString", obj.__undef__), dirty)
        if obj._offset_string[0] is not None and obj._offset_string[0] is not obj.__undef__:
            assert isinstance(obj._offset_string[0], basestring), ("Expected one of [u'string'], but got %s" % type(obj._offset_string[0]))
            common.validate_format(obj._offset_string[0], "None", None, None)
        obj._offset = (data.get("offset", obj.__undef__), dirty)
        if obj._offset[0] is not None and obj._offset[0] is not obj.__undef__:
            assert isinstance(obj._offset[0], int), ("Expected one of [u'integer'], but got %s" % type(obj._offset[0]))
            common.validate_format(obj._offset[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(TimeZone, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "id" == "type" or (self.id is not self.__undef__ and (not (dirty and not self._id[1]) or isinstance(self.id, list) or belongs_to_parent)):
            dct["id"] = dictify(self.id)
        if "offset_string" == "type" or (self.offset_string is not self.__undef__ and (not (dirty and not self._offset_string[1]))):
            dct["offsetString"] = dictify(self.offset_string)
        if "offset" == "type" or (self.offset is not self.__undef__ and (not (dirty and not self._offset[1]))):
            dct["offset"] = dictify(self.offset)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._id = (self._id[0], True)
        self._offset_string = (self._offset_string[0], True)
        self._offset = (self._offset[0], True)

    def is_dirty(self):
        return any([self._id[1], self._offset_string[1], self._offset[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, TimeZone):
            return False
        return super(TimeZone, self).__eq__(other) and \
               self.id == other.id and \
               self.offset_string == other.offset_string and \
               self.offset == other.offset

    def __ne__(self, other):
        return not self.__eq__(other)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def id(self):
        """
        The ID of this time zone. *(permitted values: ACT, AET, AGT, ART, AST,
        Africa/Abidjan, Africa/Accra, Africa/Addis_Ababa, Africa/Algiers,
        Africa/Asmara, Africa/Asmera, Africa/Bamako, Africa/Bangui,
        Africa/Banjul, Africa/Bissau, Africa/Blantyre, Africa/Brazzaville,
        Africa/Bujumbura, Africa/Cairo, Africa/Casablanca, Africa/Ceuta,
        Africa/Conakry, Africa/Dakar, Africa/Dar_es_Salaam, Africa/Djibouti,
        Africa/Douala, Africa/El_Aaiun, Africa/Freetown, Africa/Gaborone,
        Africa/Harare, Africa/Johannesburg, Africa/Juba, Africa/Kampala,
        Africa/Khartoum, Africa/Kigali, Africa/Kinshasa, Africa/Lagos,
        Africa/Libreville, Africa/Lome, Africa/Luanda, Africa/Lubumbashi,
        Africa/Lusaka, Africa/Malabo, Africa/Maputo, Africa/Maseru,
        Africa/Mbabane, Africa/Mogadishu, Africa/Monrovia, Africa/Nairobi,
        Africa/Ndjamena, Africa/Niamey, Africa/Nouakchott, Africa/Ouagadougou,
        Africa/Porto-Novo, Africa/Sao_Tome, Africa/Timbuktu, Africa/Tripoli,
        Africa/Tunis, Africa/Windhoek, America/Adak, America/Anchorage,
        America/Anguilla, America/Antigua, America/Araguaina,
        America/Argentina/Buenos_Aires, America/Argentina/Catamarca,
        America/Argentina/ComodRivadavia, America/Argentina/Cordoba,
        America/Argentina/Jujuy, America/Argentina/La_Rioja,
        America/Argentina/Mendoza, America/Argentina/Rio_Gallegos,
        America/Argentina/Salta, America/Argentina/San_Juan,
        America/Argentina/San_Luis, America/Argentina/Tucuman,
        America/Argentina/Ushuaia, America/Aruba, America/Asuncion,
        America/Atikokan, America/Atka, America/Bahia, America/Bahia_Banderas,
        America/Barbados, America/Belem, America/Belize, America/Blanc-Sablon,
        America/Boa_Vista, America/Bogota, America/Boise, America/Buenos_Aires,
        America/Cambridge_Bay, America/Campo_Grande, America/Cancun,
        America/Caracas, America/Catamarca, America/Cayenne, America/Cayman,
        America/Chicago, America/Chihuahua, America/Coral_Harbour,
        America/Cordoba, America/Costa_Rica, America/Creston, America/Cuiaba,
        America/Curacao, America/Danmarkshavn, America/Dawson,
        America/Dawson_Creek, America/Denver, America/Detroit,
        America/Dominica, America/Edmonton, America/Eirunepe,
        America/El_Salvador, America/Ensenada, America/Fort_Nelson,
        America/Fort_Wayne, America/Fortaleza, America/Glace_Bay,
        America/Godthab, America/Goose_Bay, America/Grand_Turk,
        America/Grenada, America/Guadeloupe, America/Guatemala,
        America/Guayaquil, America/Guyana, America/Halifax, America/Havana,
        America/Hermosillo, America/Indiana/Indianapolis, America/Indiana/Knox,
        America/Indiana/Marengo, America/Indiana/Petersburg,
        America/Indiana/Tell_City, America/Indiana/Vevay,
        America/Indiana/Vincennes, America/Indiana/Winamac,
        America/Indianapolis, America/Inuvik, America/Iqaluit, America/Jamaica,
        America/Jujuy, America/Juneau, America/Kentucky/Louisville,
        America/Kentucky/Monticello, America/Knox_IN, America/Kralendijk,
        America/La_Paz, America/Lima, America/Los_Angeles, America/Louisville,
        America/Lower_Princes, America/Maceio, America/Managua, America/Manaus,
        America/Marigot, America/Martinique, America/Matamoros,
        America/Mazatlan, America/Mendoza, America/Menominee, America/Merida,
        America/Metlakatla, America/Mexico_City, America/Miquelon,
        America/Moncton, America/Monterrey, America/Montevideo,
        America/Montreal, America/Montserrat, America/Nassau, America/New_York,
        America/Nipigon, America/Nome, America/Noronha,
        America/North_Dakota/Beulah, America/North_Dakota/Center,
        America/North_Dakota/New_Salem, America/Ojinaga, America/Panama,
        America/Pangnirtung, America/Paramaribo, America/Phoenix, America/Port-
        au-Prince, America/Port_of_Spain, America/Porto_Acre,
        America/Porto_Velho, America/Puerto_Rico, America/Punta_Arenas,
        America/Rainy_River, America/Rankin_Inlet, America/Recife,
        America/Regina, America/Resolute, America/Rio_Branco, America/Rosario,
        America/Santa_Isabel, America/Santarem, America/Santiago,
        America/Santo_Domingo, America/Sao_Paulo, America/Scoresbysund,
        America/Shiprock, America/Sitka, America/St_Barthelemy,
        America/St_Johns, America/St_Kitts, America/St_Lucia,
        America/St_Thomas, America/St_Vincent, America/Swift_Current,
        America/Tegucigalpa, America/Thule, America/Thunder_Bay,
        America/Tijuana, America/Toronto, America/Tortola, America/Vancouver,
        America/Virgin, America/Whitehorse, America/Winnipeg, America/Yakutat,
        America/Yellowknife, Antarctica/Casey, Antarctica/Davis,
        Antarctica/DumontDUrville, Antarctica/Macquarie, Antarctica/Mawson,
        Antarctica/McMurdo, Antarctica/Palmer, Antarctica/Rothera,
        Antarctica/South_Pole, Antarctica/Syowa, Antarctica/Troll,
        Antarctica/Vostok, Arctic/Longyearbyen, Asia/Aden, Asia/Almaty,
        Asia/Amman, Asia/Anadyr, Asia/Aqtau, Asia/Aqtobe, Asia/Ashgabat,
        Asia/Ashkhabad, Asia/Atyrau, Asia/Baghdad, Asia/Bahrain, Asia/Baku,
        Asia/Bangkok, Asia/Barnaul, Asia/Beirut, Asia/Bishkek, Asia/Brunei,
        Asia/Calcutta, Asia/Chita, Asia/Choibalsan, Asia/Chongqing,
        Asia/Chungking, Asia/Colombo, Asia/Dacca, Asia/Damascus, Asia/Dhaka,
        Asia/Dili, Asia/Dubai, Asia/Dushanbe, Asia/Famagusta, Asia/Gaza,
        Asia/Harbin, Asia/Hebron, Asia/Ho_Chi_Minh, Asia/Hong_Kong, Asia/Hovd,
        Asia/Irkutsk, Asia/Istanbul, Asia/Jakarta, Asia/Jayapura,
        Asia/Jerusalem, Asia/Kabul, Asia/Kamchatka, Asia/Karachi, Asia/Kashgar,
        Asia/Kathmandu, Asia/Katmandu, Asia/Khandyga, Asia/Kolkata,
        Asia/Krasnoyarsk, Asia/Kuala_Lumpur, Asia/Kuching, Asia/Kuwait,
        Asia/Macao, Asia/Macau, Asia/Magadan, Asia/Makassar, Asia/Manila,
        Asia/Muscat, Asia/Nicosia, Asia/Novokuznetsk, Asia/Novosibirsk,
        Asia/Omsk, Asia/Oral, Asia/Phnom_Penh, Asia/Pontianak, Asia/Pyongyang,
        Asia/Qatar, Asia/Qyzylorda, Asia/Rangoon, Asia/Riyadh, Asia/Saigon,
        Asia/Sakhalin, Asia/Samarkand, Asia/Seoul, Asia/Shanghai,
        Asia/Singapore, Asia/Srednekolymsk, Asia/Taipei, Asia/Tashkent,
        Asia/Tbilisi, Asia/Tehran, Asia/Tel_Aviv, Asia/Thimbu, Asia/Thimphu,
        Asia/Tomsk, Asia/Tokyo, Asia/Ujung_Pandang, Asia/Ulaanbaatar,
        Asia/Ulan_Bator, Asia/Urumqi, Asia/Ust-Nera, Asia/Vientiane,
        Asia/Vladivostok, Asia/Yakutsk, Asia/Yangon, Asia/Yekaterinburg,
        Asia/Yerevan, Atlantic/Azores, Atlantic/Bermuda, Atlantic/Canary,
        Atlantic/Cape_Verde, Atlantic/Faeroe, Atlantic/Faroe,
        Atlantic/Jan_Mayen, Atlantic/Madeira, Atlantic/Reykjavik,
        Atlantic/South_Georgia, Atlantic/St_Helena, Atlantic/Stanley,
        Australia/ACT, Australia/Adelaide, Australia/Brisbane,
        Australia/Broken_Hill, Australia/Canberra, Australia/Currie,
        Australia/Darwin, Australia/Eucla, Australia/Hobart, Australia/LHI,
        Australia/Lindeman, Australia/Lord_Howe, Australia/Melbourne,
        Australia/NSW, Australia/North, Australia/Perth, Australia/Queensland,
        Australia/South, Australia/Sydney, Australia/Tasmania,
        Australia/Victoria, Australia/West, Australia/Yancowinna, BET, BST,
        Brazil/Acre, Brazil/DeNoronha, Brazil/East, Brazil/West, CAT, CET, CNT,
        CST, CST6CDT, CTT, Canada/Atlantic, Canada/Central, Canada/Eastern,
        Canada/Mountain, Canada/Newfoundland, Canada/Pacific,
        Canada/Saskatchewan, Canada/Yukon, Chile/Continental,
        Chile/EasterIsland, Cuba, EAT, ECT, EET, EST, EST5EDT, Egypt, Eire,
        Etc/GMT, Etc/GMT+0, Etc/GMT+1, Etc/GMT+10, Etc/GMT+11, Etc/GMT+12,
        Etc/GMT+2, Etc/GMT+3, Etc/GMT+4, Etc/GMT+5, Etc/GMT+6, Etc/GMT+7,
        Etc/GMT+8, Etc/GMT+9, Etc/GMT-0, Etc/GMT-1, Etc/GMT-10, Etc/GMT-11,
        Etc/GMT-12, Etc/GMT-13, Etc/GMT-14, Etc/GMT-2, Etc/GMT-3, Etc/GMT-4,
        Etc/GMT-5, Etc/GMT-6, Etc/GMT-7, Etc/GMT-8, Etc/GMT-9, Etc/GMT0,
        Etc/Greenwich, Etc/UCT, Etc/UTC, Etc/Universal, Etc/Zulu,
        Europe/Amsterdam, Europe/Andorra, Europe/Astrakhan, Europe/Athens,
        Europe/Belfast, Europe/Belgrade, Europe/Berlin, Europe/Bratislava,
        Europe/Brussels, Europe/Bucharest, Europe/Budapest, Europe/Busingen,
        Europe/Chisinau, Europe/Copenhagen, Europe/Dublin, Europe/Gibraltar,
        Europe/Guernsey, Europe/Helsinki, Europe/Isle_of_Man, Europe/Istanbul,
        Europe/Jersey, Europe/Kaliningrad, Europe/Kiev, Europe/Kirov,
        Europe/Lisbon, Europe/Ljubljana, Europe/London, Europe/Luxembourg,
        Europe/Madrid, Europe/Malta, Europe/Mariehamn, Europe/Minsk,
        Europe/Monaco, Europe/Moscow, Europe/Nicosia, Europe/Oslo,
        Europe/Paris, Europe/Podgorica, Europe/Prague, Europe/Riga,
        Europe/Rome, Europe/Samara, Europe/San_Marino, Europe/Sarajevo,
        Europe/Saratov, Europe/Simferopol, Europe/Skopje, Europe/Sofia,
        Europe/Stockholm, Europe/Tallinn, Europe/Tirane, Europe/Tiraspol,
        Europe/Ulyanovsk, Europe/Uzhgorod, Europe/Vaduz, Europe/Vatican,
        Europe/Vienna, Europe/Vilnius, Europe/Volgograd, Europe/Warsaw,
        Europe/Zagreb, Europe/Zaporozhye, Europe/Zurich, GB, GB-Eire, GMT,
        GMT0, Greenwich, HST, Hongkong, IET, IST, Iceland, Indian/Antananarivo,
        Indian/Chagos, Indian/Christmas, Indian/Cocos, Indian/Comoro,
        Indian/Kerguelen, Indian/Mahe, Indian/Maldives, Indian/Mauritius,
        Indian/Mayotte, Indian/Reunion, Iran, Israel, JST, Jamaica, Japan,
        Kwajalein, Libya, MET, MIT, MST, MST7MDT, Mexico/BajaNorte,
        Mexico/BajaSur, Mexico/General, NET, NST, NZ, NZ-CHAT, Navajo, PLT,
        PNT, PRC, PRT, PST, PST8PDT, Pacific/Apia, Pacific/Auckland,
        Pacific/Bougainville, Pacific/Chatham, Pacific/Chuuk, Pacific/Easter,
        Pacific/Efate, Pacific/Enderbury, Pacific/Fakaofo, Pacific/Fiji,
        Pacific/Funafuti, Pacific/Galapagos, Pacific/Gambier,
        Pacific/Guadalcanal, Pacific/Guam, Pacific/Honolulu, Pacific/Johnston,
        Pacific/Kiritimati, Pacific/Kosrae, Pacific/Kwajalein, Pacific/Majuro,
        Pacific/Marquesas, Pacific/Midway, Pacific/Nauru, Pacific/Niue,
        Pacific/Norfolk, Pacific/Noumea, Pacific/Pago_Pago, Pacific/Palau,
        Pacific/Pitcairn, Pacific/Pohnpei, Pacific/Ponape,
        Pacific/Port_Moresby, Pacific/Rarotonga, Pacific/Saipan, Pacific/Samoa,
        Pacific/Tahiti, Pacific/Tarawa, Pacific/Tongatapu, Pacific/Truk,
        Pacific/Wake, Pacific/Wallis, Pacific/Yap, Poland, Portugal, ROK, SST,
        Singapore, SystemV/AST4, SystemV/AST4ADT, SystemV/CST6,
        SystemV/CST6CDT, SystemV/EST5, SystemV/EST5EDT, SystemV/HST10,
        SystemV/MST7, SystemV/MST7MDT, SystemV/PST8, SystemV/PST8PDT,
        SystemV/YST9, SystemV/YST9YDT, Turkey, UCT, US/Alaska, US/Aleutian,
        US/Arizona, US/Central, US/East-Indiana, US/Eastern, US/Hawaii, US
        /Indiana-Starke, US/Michigan, US/Mountain, US/Pacific, US/Pacific-New,
        US/Samoa, UTC, Universal, VST, W-SU, WET, Zulu)*

        :rtype: ``basestring``
        """
        return self._id[0]

    @id.setter
    def id(self, value):
        self._id = (value, True)

    @property
    def offset_string(self):
        """
        The Offset as a String. For instance 'UTC -5:00'.

        :rtype: ``basestring``
        """
        return self._offset_string[0]

    @offset_string.setter
    def offset_string(self, value):
        self._offset_string = (value, True)

    @property
    def offset(self):
        """
        The difference, in minutes, between UTC and local time. For example, if
        your time zone is UTC -5:00 (Eastern Standard Time), 300 will be
        returned. Daylight saving time prevents this value from being a
        constant even for a given locale.

        :rtype: ``int``
        """
        return self._offset[0]

    @offset.setter
    def offset(self, value):
        self._offset = (value, True)

