#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from contextlib import closing

global _ci

progressions = []
if _ci.server:
    with closing(_ci.getClient()) as client:
        start = 0
        count = 50
        while True:
            resp = client.listProgressions(start, count)
            progressions += [{"id": p["id"], "name": p["name"]} for p in resp.results()]
            start = resp.pagination().next_start()
            if not start:
                break
else:
    raise Exception("Delivery Insights Service was not provided")

result = [LookupResultElement(p["name"], p["name"]) for p in progressions]
