'use strict';

(function () {
    angular.module('xlrelease.dashboard', ['gridster', 'ngRoute', 'mgcrea.ngStrap']).config(['$routeProvider', function ($routeProvider) {
        var xlrTileDetailsRoute = {
            templateUrl: 'static/5.0.1/include/DashboardPage/xlr-dashboard-details-mode.html',
            controller: 'xlrelease.dashboard.XlrTileDetailsController',
            controllerAs: 'xlrTileDetailsCtrl',
            resolve: {
                tilePromise: ['xlrelease.XlrDashboardService', '$route', function (XlrDashboardService, $route) {
                    return XlrDashboardService.loadTile('Applications/' + $route.current.params.releaseId + '/summary/' + $route.current.params.tileId);
                }],
                releasePromise: ['ReleasesService', '$route', function (ReleasesService, $route) {
                    return ReleasesService.getReleaseWithDependencies($route.current.params.releaseId);
                }]
            }
        };

        $routeProvider.when('/releases/:releaseId/summary/:tileId/details', xlrTileDetailsRoute).when('/templates/:releaseId/summary/:tileId/details', xlrTileDetailsRoute);
    }]);

    angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
        return {
            getConfig: function getConfig(designMode) {
                return {
                    minRows: 1,
                    maxSizeX: 4,
                    pushing: true, // whether to push other items out of the way on move or resize
                    floating: true, // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
                    swapping: true, // whether or not to have items of the same size switch places instead of pushing down if they are the same size
                    columns: 3, // the width of the grid, in columns
                    colWidth: 'auto', // can be an integer or 'auto'.  'auto' uses the pixel width of the element divided by 'columns'
                    minSizeY: 1, // minumum row height of an item
                    maxSizeY: 1, // maximum row height of an item
                    rowHeight: 290, // can be an integer or 'match'.  Match uses the colWidth, giving you square widgets.
                    margins: [20, 20], // the pixel distance between each widget
                    defaultSizeX: 1, // the default width of a gridster item, if not specifed
                    defaultSizeY: 1, // the default height of a gridster item, if not specified
                    mobileBreakPoint: 60, // if the screen is not wider that this, remove the grid layout and stack the items
                    resizable: {
                        enabled: designMode,
                        handles: ['e', 'w'],
                        start: function start(event, uiWidget, $element) {}, // optional callback fired when resize is started,
                        resize: function resize(event, uiWidget, $element) {}, // optional callback fired when item is resized,
                        stop: function stop(event, uiWidget, $element) {} // optional callback fired when item is finished resizing
                    },
                    draggable: {
                        enabled: designMode, // whether dragging items is supported
                        handle: '.xlr-widget-drag-handle', // optional selector for drag handle
                        start: function start(event, uiWidget, $element) {}, // optional callback fired when drag is started,
                        drag: function drag(event, uiWidget, $element) {}, // optional callback fired when item is moved,
                        stop: function stop(event, uiWidget, $element) {} // optional callback fired when item is finished dragging
                    }
                };
            }
        };
    });
})();