package com.xebialabs.xlrelease.plugins.dashboard.domain;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;

/**
 * A dashboard with tiles displayed in XL Release UI.
 */
@Metadata(versioned = false, description = "A dashboard with tiles displayed in XL Release UI")
public class Dashboard extends ReleaseExtension {

    @Property(asContainment = true, description = "Tiles in this dashboard", required = false)
    private List<Tile> tiles = new ArrayList<>();

    public List<Tile> getTiles() {
        return tiles;
    }

    public void setTiles(final List<Tile> tiles) {
        this.tiles = tiles;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        tiles.forEach(visitor::visit);
    }
}
