package com.xebialabs.xlrelease.plugins.dashboard.builder

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}

import scala.collection.JavaConversions._

object DashboardBuilder {
  def newDashboard: DashboardBuilder = new DashboardBuilder

  def newTile: TileBuilder = new TileBuilder
}

class DashboardBuilder {

  private var id: String = _
  private var tiles: List[Tile] = List[Tile]()

  def withId(id: String) = {
    this.id = id
    this
  }

  def withTiles(tiles: Tile*) = {
    this.tiles = tiles.toList
    this
  }

  def build: Dashboard = {
    val dashboard: Dashboard = Type.valueOf(classOf[Dashboard]).getDescriptor.newInstance(id)
    dashboard.setTiles(tiles)
    dashboard
  }
}

class TileBuilder {

  private var id: String = _
  private var `type`: String = _
  private var title: String = _
  private var width: Integer = _
  private var row: Integer = _
  private var col: Integer = _
  private var properties: Map[String, AnyRef] = Map.empty
  private var variableMappings: Map[String, String] = Map.empty

  def withId(id: String) = {
    this.id = id
    this
  }

  def withType(`type`: String) = {
    this.`type` = `type`
    this
  }

  def withTitle(title: String) = {
    this.title = title
    this
  }

  def withWidth(width: Integer) = {
    this.width = width
    this
  }

  def withRow(row: Integer) = {
    this.row = row
    this
  }

  def withCol(col: Integer) = {
    this.col = col
    this
  }

  def withProperties(properties: Map[String, AnyRef]) = {
    this.properties = properties
    this
  }

  def withProperty(name: String, value: AnyRef) = {
    this.properties = this.properties + (name -> value)
    this
  }

  def withVariableMappings(variableMappings: Map[String, String]) = {
    this.variableMappings = variableMappings
    this
  }

  def withVariableMapping(name: String, variable: String) = {
    this.variableMappings = this.variableMappings + (name -> variable)
    this
  }

  def build: Tile = {
    val tile: Tile = Type.valueOf(`type`).getDescriptor.newInstance(id)
    if (title != null) tile.setTitle(title)
    if (width != null) tile.setWidth(width)
    if (row != null) tile.setRow(row)
    if (col != null) tile.setCol(col)
    if (properties != null) {
      properties.foreach(p => tile.setProperty(p._1, p._2))
    }
    if(variableMappings != null) {
      tile.setVariableMapping(variableMappings)
    }
    tile
  }
}

