'use strict';

(function () {

    var xlrTileControllerInject = ['$scope', 'VariablesService', '$location'];
    var XlrTileController = function XlrTileController(scope, VariablesService, $location) {
        var vm = this;
        vm.buttons = {};
        vm.tile = scope.tile;
        vm.title = vm.tile.title;
        vm.addButton = addButton;
        vm.onBtnClick = onBtnClick;
        vm.configure = configure;
        vm.view = view;
        vm.save = save;
        vm.remove = remove;
        vm.showDeleteDialog = showDeleteDialog;
        vm.hideDeleteDialog = hideDeleteDialog;
        vm.details = details;

        vm.configUrl = getConfigUrl(vm.tile.configurationUri);
        vm.detailsUrl = tileOrDefaultUrl(vm.tile.detailsUri);
        vm.templateUrl = tileOrDefaultUrl(vm.tile.uri);
        vm.hasDetailsMode = vm.tile.detailsUri ? true : false;
        vm.configurationPropertyDefinitions = getConfigurationPropertyDefinitions(scope.tileTypeDefinition);
        vm.variables = scope.variables;
        vm.createVariable = createVariable;

        ///

        function getConfigUrl(configuredUrl) {
            return tileOrDefaultUrl(configuredUrl, 'static/5.0.0/include/DashboardPage/partials/tile-dip-config.html');
        }

        function getConfigurationPropertyDefinitions(tileTypeDefinition) {
            return _.filter(tileTypeDefinition.properties, function (property) {
                return property.category === 'input' && property.hidden !== true;
            });
        }

        function tileOrDefaultUrl(uri, defaultUri) {
            if (_.isUndefined(defaultUri)) {
                defaultUri = 'static/5.0.0/include/DashboardPage/partials/no-uri.html';
            }
            if (_.isEmpty(uri)) {
                return defaultUri;
            }
            return 'static/5.0.0/' + uri;
        }

        function details() {
            if (vm.hasDetailsMode && scope.dashboardMode !== 'design') {
                var subPath = scope.release.status === 'TEMPLATE' ? 'templates' : 'releases';
                $location.path('/' + vm.tile.id.replace('Applications', subPath) + '/details');
            }
        }

        function configure() {
            vm.tile = angular.copy(scope.tile);
            vm.state = 'config';
        }

        function view() {
            vm.state = 'view';
        }

        function save() {
            scope.save({ item: vm.tile });
            view();
        }

        function remove() {
            scope.remove({ item: vm.tile });
        }

        function addButton(btn) {
            if (!_(vm.buttons).includes(btn.title)) {
                vm.buttons[btn.title] = btn;
            }
        }

        function onBtnClick(btn) {
            btn.onClick();
        }

        function showDeleteDialog() {
            vm.deleteDialogVisible = true;
        }

        function hideDeleteDialog() {
            vm.deleteDialogVisible = false;
        }

        function createVariable(name, variableType, createdCallback) {
            var variable = {
                key: name,
                type: variableType
            };
            VariablesService.createReleaseVariable(scope.release.id, variable).success(function (variable) {
                if (createdCallback) {
                    createdCallback(variable);
                }
            });
        }
    };
    XlrTileController.$inject = xlrTileControllerInject;

    var xlrTileInject = ['$timeout', '$window', 'Events'];
    var XlrTile = function XlrTile($timeout, $window, Events) {
        return {
            scope: {
                tile: '=',
                tileTypeDefinition: '=',
                release: '=',
                variables: '=',
                dashboardMode: '=',
                remove: '&',
                save: '&'
            },
            restrict: 'A',
            templateUrl: 'static/5.0.0/include/DashboardPage/xlr-tile.html',
            controller: 'xlrelease.dashboard.XlrTileController',
            controllerAs: 'xlrTile',
            require: ['xlrTile', '^xlrDashboard'],
            link: function link(scope, elem, attr, ctrls) {
                var vm = ctrls[0];
                scope.xlrDashboard = ctrls[1];

                vm.setTitle = function (transcludedContent) {
                    elem.find('.tile-title span').replaceWith(transcludedContent);
                };

                function adjustTileDimensions(el) {
                    var panelContent = el.find('.panel');
                    var panelHeading = el.find('.panel-heading');
                    var panelFooter = el.find('.panel-footer');
                    var panelBody = el.find('.panel-body');
                    var contentHeight = panelContent.outerHeight();
                    var headerHeight = panelHeading.outerHeight();
                    var footerHeight = panelFooter.outerHeight();
                    var handleHeight = 16;
                    if (footerHeight) {
                        handleHeight = 0;
                    } else {
                        footerHeight = 0;
                    }
                    var newHeight = contentHeight - headerHeight - footerHeight - handleHeight;
                    panelBody.css('height', newHeight);
                    panelBody.css('max-height', newHeight);
                    panelBody.css('min-height', newHeight);
                    vm.height = panelBody.innerHeight();
                    vm.width = panelBody.width();
                    scope.$broadcast(Events.tile.resized);
                }

                scope.$on('gridster-item-transition-end', function (event) {
                    adjustTileDimensions(event.targetScope.gridsterItem.$element);
                });
                scope.$on('gridster-item-initialized', function (event) {
                    $timeout(function () {
                        adjustTileDimensions(event.targetScope.gridsterItem.$element);
                    }, 200);
                });
                scope.$on('gridster-item-resized', function (event) {
                    adjustTileDimensions(event.targetScope.gridsterItem.$element);
                });

                var resizeFn = function resizeFn() {
                    $timeout(function () {
                        adjustTileDimensions(elem);
                    }, 200);
                };
                angular.element($window).bind('resize', resizeFn);
                scope.$on('$destroy', function () {
                    angular.element($window).unbind('resize', resizeFn);
                });
            }
        };
    };
    XlrTile.$inject = xlrTileInject;

    angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileController', XlrTileController);
    angular.module('xlrelease.dashboard').directive('xlrTile', XlrTile);
})();