import json
import urllib2
from com.xebialabs.deployit.plugin.api.reflect import Type
from com.xebialabs.deployit.util import PasswordEncrypter
from org.apache.http.client import ClientProtocolException
from xlrelease.HttpRequest import HttpRequest

global configurationApi, customer, username, password, regions

# Get token endpoint for region
api_url = None
token_endpoint = None
for region in regions:
    api_url = "https://api.{}.digital.ai".format(region)
    configuration_url = "{}/identity/v1/accounts/{}/.well-known/openid-configuration".format(api_url, customer)
    try:
        response = urllib2.urlopen(configuration_url)
        data = response.read()
        json_data = json.loads(data)
        token_endpoint = json_data.get("token_endpoint")
        if token_endpoint:
            break
    except Exception as e:
        pass

if not token_endpoint:
    raise Exception("No token endpoint found for customer ${customer}")

# Test credentials
params = {
    'url': api_url,
    'authenticationMethod': "OAuth2",
    'username': username,
    'password': password,
    'oauth2GrantType': "Password",
    'accessTokenUrl': token_endpoint,
    'clientId': "dai-svc-consumer",
    'scope': "openid dai-svc"
}

try:
    request = HttpRequest(params)
    response = request.get("identity/v1/users/self")
except ClientProtocolException:
    raise Exception("Failed to connect to Digital.ai Platform: URL is not valid")

if not response.isSuccessful():
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    elif response.status == 403:
        reason = "Forbidden"
    raise Exception("Failed to connect to Digital.ai Platform: HTTP response code %s (%s)" % (response.status, reason))

# Create CI
server = Type.valueOf("daiplatform.Server").getDescriptor().newInstance(None)

server.setProperty("title", customer)
server.setProperty("url", api_url)
server.setProperty("authenticationMethod", "OAuth2")
server.setProperty("username", username)
server.setProperty("accessTokenUrl", token_endpoint)
server.setProperty("clientId", "dai-svc-consumer")
server.setProperty("scope", "openid dai-svc")

# Set password
encrypted = password
enc = PasswordEncrypter.getInstance()
decrypted = enc.ensureDecrypted(encrypted)
server.setProperty("password", decrypted)

# Add Digital.ai Platform connection
configuration = configurationApi.addConfiguration(server)
output = configuration.getId()
