#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from crp.Client import getChangeRiskPrediction

crpValue = getChangeRiskPrediction(server, changeRequestNumber, projectName, CRPModel)
stringChangePredictionProbablity = "{:.2f}".format(crpValue * 100)
changePredictionProbablity = float(stringChangePredictionProbablity)
print("Change Risk Prediction Value: {0}".format(crpValue))

def check_percentage(threshold_percentage):
    print("Change Prediction Probablity: {:.2f}%".format(changePredictionProbablity))
    print("Change Prediction Threshold: {0}".format(threshold_percentage))
    if changePredictionProbablity > float(threshold_percentage):
        raise Exception("Percentage {0} exceeds threshold of {1}.".format(changePredictionProbablity, threshold_percentage))
    return changePredictionProbablity

try:
    result = check_percentage(threshold)
except Exception as e:
    exit(e)
