#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from contextlib import closing

global _ci

progressions = []
if _ci.server:
    with closing(_ci.getClient()) as client:
        resp = client.listProgressions().Response()
        progressions = [p["name"] for p in resp]
else:
    raise Exception("Delivery Insights Service was not provided")

result = [LookupResultElement(p, p) for p in progressions]
