#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.continuum import RunAPipelineRequest
from contextlib import closing

from continuum import get_client

global task
global unwrap

global definition
global project
global group
global should_wait
global pipeline_status
global details
global continuumServer


def run_a_pipeline(client):
    global pipeline_instance_id
    global instance_name

    if instance_name == "":
        instance_name = None

    res = client.runAPipeline(RunAPipelineRequest(
        definition,
        project,
        group,
        instance_name,
        unwrap(details)
    ))
    return res


def pipeline_link(server_url, pipeline_definition, pipeline_instance_id):
    pipeline_title = "{} ({})".format(pipeline_definition, pipeline_instance_id)
    pipeline_url = "{}/flow/pi_detail?id={}".format(server_url.rstrip("/"), pipeline_instance_id)
    return "[{}]({})".format(pipeline_title, pipeline_url)


with closing(get_client(task)) as client:
    resp = run_a_pipeline(client).Response()
    status = resp.get("status", "")
    pipeline_instance_id = resp.get("_id", "")
    task.setStatusLine("Status: {}.".format(status))
    pipeline_md = pipeline_link(continuumServer["url"], definition, pipeline_instance_id)
    print "Pipeline {} has started".format(pipeline_md)
    if should_wait:
        task.schedule("continuum/RunAPipeline.wait.py")
    else:
        response = resp
        pipeline_status = status
        print "Pipeline {} has ended".format(pipeline_md)
