#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.continuum import PromoteAPackageRequest
from contextlib import closing

from continuum import get_client

global task

global package
global phase_name


def promote_a_package(client):

    global revision
    global full_version
    global new_version

    if revision == "":
        revision = None

    if full_version == "":
        full_version = None

    if new_version == "":
        new_version = None

    res = client.promoteAPackage(PromoteAPackageRequest(
        package,
        revision,
        phase_name,
        full_version,
        new_version
    ))
    return res


with closing(get_client(task)) as client:
    response = promote_a_package(client).Response()
    print "Promoted a package for {}".format(package)
