#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

global tile
global logger
global _configurationApi

global server
global progression
global packages
global teams

server = tile.getProperty("server")
if server and progression:
    with closing(server.getClient()) as client:
        resp = client.getProgressionDetails(progression, packages, teams)
        if resp.ErrorCode() == "":
            data = {
                "response": resp.Response(),
                "baseUrl": server.getUrl()
            }
        else:
            data = {
                "error": resp.ErrorMessage()
            }
else:
    data = {
        "error": "Please configure the tile. Server and Progression properties MUST be provided."
    }
