/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.continuum.connector;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.plugin.continuum.connector.HttpClientWrapper;
import com.xebialabs.xlrelease.plugin.continuum.connector.ProxyConfiguration;
import com.xebialabs.xlrelease.plugin.continuum.connector.ResponseErrorHandler$;
import com.xebialabs.xlrelease.plugin.continuum.connector.ServerConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class HttpClientWrapper$ {
    public static HttpClientWrapper$ MODULE$;

    static {
        new HttpClientWrapper$();
    }

    public HttpClientWrapper apply(ServerConfiguration configuration) {
        return new HttpClientWrapper(configuration.url(), this.restTemplate(configuration)).withAuth(configuration);
    }

    private RestTemplate restTemplate(ServerConfiguration serverConfiguration) {
        CloseableHttpClient httpClient = this.getDefaultClient(serverConfiguration);
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpComponentsClientHttpRequestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)ResponseErrorHandler$.MODULE$);
        return restTemplate;
    }

    public CloseableHttpClient getDefaultClient(ServerConfiguration serverConfiguration) {
        BoxedUnit boxedUnit;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (serverConfiguration.proxyConfiguration() != null) {
            BoxedUnit boxedUnit2;
            ProxyConfiguration proxyConfig = serverConfiguration.proxyConfiguration();
            String proxyHost = proxyConfig.host();
            String proxyPort = proxyConfig.port();
            if (Strings.isNotBlank((String)proxyHost) && Strings.isNotBlank((String)proxyPort)) {
                HttpHost proxy = new HttpHost(proxyHost, new StringOps(Predef$.MODULE$.augmentString(proxyPort)).toInt());
                boxedUnit2 = httpClientBuilder.setProxy(proxy);
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String proxyUsername = proxyConfig.username();
            String proxyPassword = proxyConfig.password();
            if (Strings.isNotBlank((String)proxyUsername) && Strings.isNotBlank((String)proxyPassword)) {
                BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
                credentialProvider.setCredentials(new AuthScope(proxyHost, new StringOps(Predef$.MODULE$.augmentString(proxyPort)).toInt()), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                boxedUnit = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int connectionTimeout = serverConfiguration.connectionConfiguration().timeout();
        httpClientBuilder.setConnectionTimeToLive((long)connectionTimeout, TimeUnit.SECONDS);
        httpClientBuilder.disableCookieManagement();
        return httpClientBuilder.build();
    }

    public <T> HttpClientWrapper.ResponseEntityExtension<T> ResponseEntityExtension(ResponseEntity<T> response) {
        return new HttpClientWrapper.ResponseEntityExtension<T>(response);
    }

    private HttpClientWrapper$() {
        MODULE$ = this;
    }
}

