#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.continuum import CreateUserRequest
from contextlib import closing
from java.text import SimpleDateFormat

from continuum import get_client

global task

global user
global full_name
global teams
global role
global password
global email
global auth_type
global force_change
global status
global expires
global groups
global contributors
global get_token


def create_user(client):
    global password

    fmt = SimpleDateFormat("MM/dd/yyyy")
    expires_str = fmt.format(expires)
    teams_str = ",".join([k + ":" + v for k, v in teams.items()])
    groups_str = ",".join(groups)
    contribs_str = ",".join(contributors)

    if password == "":
        password = None

    res = client.createUser(CreateUserRequest(
        user,
        full_name,
        teams_str,
        role,
        password,
        email,
        auth_type,
        force_change,
        status,
        expires_str,
        groups_str,
        contribs_str,
        get_token
    ))
    return res


with closing(get_client(task)) as client:
    response = create_user(client).Response()
    print "Created user with id {}".format(response.get("_id"))
