#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

from com.xebialabs.xlrelease.plugin.continuum import JenkinsPluginConfigurationRequest

from continuum import get_client

global jenkinsServer
global task

title = jenkinsServer["title"]
url = jenkinsServer["url"]
username = jenkinsServer["username"]
api_token = jenkinsServer["password"]


def sync(client):
    config = JenkinsPluginConfigurationRequest(
        "jenkins",
        title,
        username,
        None,
        api_token,
        url,
        None
    )
    return client.configureJenkinsPlugin(config)


with closing(get_client(task)) as client:
    response = sync(client).Response()
    print "Created Jenkins server {}".format(title)
