/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.util;

import com.cyberark.conjur.util.Args;
import java.io.UnsupportedEncodingException;

public final class TextUtils {
    public static String join(CharSequence glue, CharSequence[] parts) {
        if (parts.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            sb.append(glue);
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static boolean isEmpty(CharSequence s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static boolean isBlank(CharSequence s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getString(byte[] data, int offset, int length, String charset) {
        Args.notNull(data, "Input");
        Args.notEmpty(charset, "Charset");
        try {
            return new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, offset, length);
        }
    }

    public static byte[] getBytes(String data, String charset) {
        Args.notNull(data, "Input");
        Args.notEmpty(charset, "Charset");
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }
}

