/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.conjur;

import com.cyberark.conjur.api.Credentials;
import com.cyberark.conjur.api.Endpoints;
import com.cyberark.conjur.api.clients.AuthnClient;
import com.cyberark.conjur.util.rs.TokenAuthFilter;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.plugin.conjur.ExternalVariableResolutionFailedException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="Conjur Server")
public class ConjurServer
extends ExternalVariableServer {
    private static final Logger logger = LoggerFactory.getLogger(ConjurServer.class);
    @Property(description="Script Location", required=false, hidden=true, defaultValue="conjur/control/check_connection.py")
    private String scriptLocation;
    @Property(label="Account", required=true, category="Authentication")
    private String account;
    @Property(label="Username", required=true, category="Authentication")
    private String username;

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        try (Client client = null;){
            ClientBuilder builder = this.createClientBuilder();
            if (builder != null) {
                client = builder.build();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public ClientBuilder createClientBuilder() {
        String serverAddress = this.getUrl();
        Endpoints endpoints = this.createEndPoints();
        return this.createConnection(serverAddress, endpoints);
    }

    public Endpoints createEndPoints() {
        String serverAddress = this.getUrl();
        URI authUrl = URI.create(serverAddress + "/authn/" + this.account);
        URI secretsUrl = URI.create(serverAddress + "/secrets/" + this.account + "/variable");
        return new Endpoints(authUrl, secretsUrl);
    }

    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        ClientBuilder builder = this.createClientBuilder();
        String path = "";
        try (Client client = null;){
            client = builder.build();
            WebTarget webTarget = client.target(this.createEndPoints().getSecretsUri());
            for (PasswordStringVariable var : variables) {
                ExternalVariableValue externalVariableValue = var.getExternalVariableValue();
                path = externalVariableValue.getPath();
                String mySecret = this.retrieveSecret(webTarget, path);
                lookupMap.put(var.getKey(), mySecret);
            }
        }
        return lookupMap;
    }

    private ClientBuilder createConnection(String serverAddress, Endpoints endpoints) {
        String apiToken = PasswordEncrypter.getInstance().ensureDecrypted(this.getToken());
        try {
            Credentials credentials = new Credentials(this.username, apiToken, endpoints.getAuthnUri().toString());
            return (ClientBuilder)ClientBuilder.newBuilder().register((Object)new TokenAuthFilter(new AuthnClient(credentials, endpoints)));
        }
        catch (Exception e) {
            throw new ExternalVariableResolutionFailedException("Unable to communicate with Conjur server '%s'. Please make sure account='%s', username='%s' and token=[not shown] are all correct", serverAddress, this.account, this.username);
        }
    }

    private String retrieveSecret(WebTarget webTarget, String path) {
        Response response = (Response)webTarget.path(path).request().get(Response.class);
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new ExternalVariableResolutionFailedException(errorMessage, status);
        }
        String value = (String)response.readEntity(String.class);
        if (value != null) {
            return value;
        }
        throw new ExternalVariableResolutionFailedException("Retrieve secret not valid for policy -> %s ", path);
    }

    private void checkCredentials(WebTarget webTarget, String path) {
        Response response = (Response)webTarget.path(path).request().get(Response.class);
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new ExternalVariableResolutionFailedException(errorMessage, status);
        }
        throw new ExternalVariableResolutionFailedException("Cannot Authenticate the User", new Object[0]);
    }
}

