#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

class Risk(object):
    def __init__(self, value, threshold, type):
        self.__value = value
        self.__threshold = threshold
        self.__type = type

    def validate(self):
        if self.__threshold is None or self.__value is None or self.__value <= self.__threshold:
            return True
        else:
            return False

    def get_value(self):
        return self.__value

    def get_threshold(self):
        return self.__threshold

    def get_type(self):
        return self.__type

    def get_display_text(self):
        return "|{0}|{1}|{2}|{3}|".format(self.get_type(),
                                          self.get_value(),
                                          self.get_threshold(),
                                          "Pass" if self.validate() else "Fail")

class RiskProfile(object):
    def __init__(self, risk_high, risk_medium, risk_low):
        self.__risk_high = risk_high
        self.__risk_medium = risk_medium
        self.__risk_low = risk_low

    def validate(self):
        return self.__risk_high.validate() and self.__risk_medium.validate() and self.__risk_low.validate()
