#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import logging

from checkmarx.task import *

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

logger = logging.getLogger("ListPresets")
logger.addHandler(logging.StreamHandler(sys.stdout))

output = CheckmarxService.get_presets(checkmarx_server=checkmarxOneServer,is_checkmarx_one=True)

preset_list = []

presets = output["presets"]
for preset in presets:
    preset_list.append(LookupResultElement(preset['name'], preset['name']))

result = preset_list