#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import time
import  java
import sys
import yaml

from checkmarx import CheckmarxService
from checkmarx.task.helper.constant import BaseStatus
from checkmarx.task.helper.constant import ScanStatus


def add_comment(comment):
    '''
    To add comment for Plugin Task
    :param comment: the comment
    :return:
    '''
    print("```")
    print(comment)
    print("```")


def get_base_scan_status(scan_status):
    '''
    Perform validation for scan status
    :param scan_status: Checkmarx scan status
    :return: base status if scan is failed, succeeded or in progress
    '''
    if scan_status in [ScanStatus.STATUS_FAILED, ScanStatus.STATUS_CANCELED, ScanStatus.STATUS_DELETED,
                       ScanStatus.STATUS_UNKNOWN]:
        return BaseStatus.BASE_STATUS_FAILED
    elif scan_status == ScanStatus.STATUS_FINISHED or scan_status == ScanStatus.STATUS_COMPLETED:
        return BaseStatus.BASE_STATUS_SUCCEEDED
    else:
        return BaseStatus.BASE_STATUS_IN_PROGRESS

def get_checkmarxone_base_scan_status(scan_status):
    '''
    Perform validation for scan status
    :param scan_status: Checkmarx scan status
    :return: base status if scan is failed, succeeded or in progress
    '''
    if scan_status in [ScanStatus.STATUS_FAILED, ScanStatus.STATUS_CANCELED, ScanStatus.STATUS_DELETED,
                       ScanStatus.STATUS_UNKNOWN]:
        return BaseStatus.BASE_STATUS_FAILED
    elif scan_status == ScanStatus.STATUS_COMPLETED or scan_status == ScanStatus.STATUS_PARTIAL:
        return BaseStatus.BASE_STATUS_COMPLETED
    else:
        return BaseStatus.BASE_STATUS_IN_RUNNING

def validate_mandatory_field(field, error):
    '''
    Perform Validation on field
    :param field: the field
    :param error: the error message
    :return:
    '''
    if not field:
        raise Exception(error)

def add_code_compliance_record(task_reporting_api, task, checkmarx_server, project=None, project_url=None,
                                  outcome=None, compliance_data=None, analysis_date=None):
        try:
            record = task_reporting_api.newCodeComplianceRecord()
            record.targetId = task.id
            record.serverUrl = checkmarx_server['url']
            record.serverUser = checkmarx_server['username']
            record.project = project
            record.project_url = project_url
            record.outcome = outcome
            record.complianceData = yaml.dump(compliance_data, default_flow_style=False)
            record.analysisDate = analysis_date
            task_reporting_api.addRecord(record, True)
        except:
            exctype, value = sys.exc_info()[:2]
            print("{} occurred while creating `udm.CodeComplianceRecord` - {}".format(exctype, value))
