#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import sys

from checkmarx.task import *
from checkmarx.task.helper.risk_profile import *

try:
    validate_mandatory_field(checkmarxOneServer, "CheckmarxOne server ID must be provided")
    validate_mandatory_field(projectName, "Missing value for Project Name")

    if not scanId:
        checkmarx_scan_result = CheckmarxService.get_latest_sast_result_stats(checkmarx_server=checkmarxOneServer, project_id=projectName, is_checkmarx_one=True)
    else:
        checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxOneServer, scan_id=scanId, is_checkmarx_one=True)

        base_status = get_checkmarxone_base_scan_status(scan_status=checkmarx_scan_status["status"])
        if base_status == BaseStatus.BASE_STATUS_IN_RUNNING:
            add_comment("CheckmarxOne SAST Scan is in progress for scan id : %s. Can not retrieve result." % scanId)
            sys.exit(1)
        elif base_status == BaseStatus.BASE_STATUS_FAILED:
            add_comment("CheckmarxOne SAST Scan is failed or canceled for scan id : %s. Can not retrieve result." % scanId)
            sys.exit(1)
        else:
            checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxOneServer, scan_id=scanId, is_checkmarx_one=True)
    risk_high = Risk(0, 0, "High")
    risk_medium = Risk(0, 0, "Medium")
    risk_low = Risk(0, 0, "Low")
    for severity in checkmarx_scan_result["scansSummaries"][0]["scaCounters"]["severityCounters"]:
        if severity["severity"] == "HIGH":
            risk_high = Risk(severity["counter"], securityRiskHighThreshold, "High")
        if severity["severity"] == "MEDIUM":
            risk_medium = Risk(severity["counter"], securityRiskHighThreshold, "Medium")
        if severity["severity"] == "LOW":
            risk_low = Risk(severity["counter"], securityRiskLowThreshold, "Low")

    security_risk_profile = RiskProfile(risk_high, risk_medium, risk_low)
    print("Scan Id : " + str(checkmarx_scan_result["scansSummaries"][0]["scanId"]) + "\n")
    status = "| Severity       |      Value       |  Threshold    |   Status  | \n"
    status += "|--------------- |:----------------:|:-------------:|:---------:| \n"
    status += risk_high.get_display_text() + "\n"
    status += risk_medium.get_display_text() + "\n"
    status += risk_low.get_display_text() + "\n"
    status += "\n&nbsp;\n"
    print(status)

    compliance_data = {}
    compliance_data[str(risk_high.get_type())] = {
        "Value": str(risk_high.get_value()),
        "Threshold": str(risk_high.get_threshold()),
        "Status": "Pass" if risk_high.validate() else "Fail"
    }
    compliance_data[str(risk_medium.get_type())] = {
        "Value": str(risk_medium.get_value()),
        "Threshold": str(risk_medium.get_threshold()),
        "Status": "Pass" if risk_medium.validate() else "Fail"
    }
    compliance_data[str(risk_low.get_type())] = {
        "Value": str(risk_low.get_value()),
        "Threshold": str(risk_low.get_threshold()),
        "Status": "Pass" if risk_low.validate() else "Fail"
    }
    scanId = str(checkmarx_scan_result["scansSummaries"][0]["scanId"])
    compliance_data["ScanId"] = scanId
    analysis_date = CheckmarxService.get_scan_status(checkmarxOneServer, scanId, is_checkmarx_one=True)['createdAt']

    if security_risk_profile.validate():
        add_code_compliance_record(taskReportingApi, task, checkmarxOneServer, project=projectName, project_url="Not available",
                                   outcome="PASSED", compliance_data=compliance_data, analysis_date=analysis_date)
    else:
        add_comment("Issues count is higher than allowed threshold")
        add_code_compliance_record(taskReportingApi, task, checkmarxOneServer, project=projectName, project_url="Not available",
                                   outcome="FAILED", compliance_data=compliance_data, analysis_date=analysis_date)
        sys.exit(1)


except Exception as e:
    add_comment("Exception occurred: %s " % e)
    sys.exit(1)
