#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import org.apache.http.conn.HttpHostConnectException

from checkmarx.task import *

try:
    validate_mandatory_field(checkmarxServer, "Checkmarx server ID must be provided")
    validate_mandatory_field(team, "Missing value for Team")
    validate_mandatory_field(projectName, "Missing value for Project Name")

    checkmarx_team_id = CheckmarxService.get_team_id_by_name(checkmarx_server=checkmarxServer, team_name=team)

    project_list = CheckmarxService.get_project(checkmarx_server=checkmarxServer, project_name=projectName,
                                                team_id=checkmarx_team_id)
    if project_list:
        checkmarx_project_id = project_list[0]["id"]
    else:
        raise Exception("Could not get project data for : %s" % projectName)

    if not scanId:
        project_scan_id = CheckmarxService.get_latest_sast_scan_id(checkmarx_server=checkmarxServer,
                                                                   project_id=checkmarx_project_id)
        checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                 scan_id=project_scan_id)
        checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxServer,
                                                                        scan_id=project_scan_id)
    else:
        project_scan_id = scanId
        checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                 scan_id=project_scan_id)
        if checkmarx_scan_status["project"]["id"] != checkmarx_project_id:
            error_message = "Can't retrieve CxSAST Scan result for project {} with scan id {}.".format(projectName, project_scan_id)
            raise Exception(error_message)

        base_status = get_base_scan_status(scan_status=checkmarx_scan_status["status"]["name"])
        if base_status == BaseStatus.BASE_STATUS_IN_PROGRESS:
            error_message = "CxSAST Scan is in progress for scan id : %s. Can not retrieve result." % project_scan_id
            raise Exception(error_message)
        elif base_status == BaseStatus.BASE_STATUS_FAILED:
            error_message = "CxSAST Scan is failed or canceled for scan id : %s. Can not retrieve result." % project_scan_id
            raise Exception(error_message)
        else:
            checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxServer,
                                                                            scan_id=project_scan_id)

    data = checkmarx_scan_result
    data['projectName'] = projectName
    data['projectId'] = checkmarx_project_id
    data['team'] = team
    data['checkmarxUrl'] = checkmarxServer['url']
    data['scanId'] = project_scan_id
    data['scanRiskSeverity'] = checkmarx_scan_status["scanRiskSeverity"]

except org.apache.http.conn.HttpHostConnectException as e:
    print("Connection Failed: {0} ".format(str(e)))
    data = {'error': [{'msg': e.getMessage()}]}

except Exception as e:
    print("Exception occurred: {0} ".format(str(e)))
    data = {'error': [{'msg': str(e)}]}
