/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.credentials;

import com.synopsys.integration.rest.credentials.CredentialsField;
import com.synopsys.integration.validator.AbstractValidator;
import com.synopsys.integration.validator.ValidationResult;
import com.synopsys.integration.validator.ValidationResultEnum;
import com.synopsys.integration.validator.ValidationResults;
import org.apache.commons.lang3.StringUtils;

public class CredentialsValidator
extends AbstractValidator {
    private String username;
    private String password;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateCredentials(result);
        return result;
    }

    public void validateCredentials(ValidationResults result) {
        this.validateUsername(result);
        this.validatePassword(result);
    }

    public void validateUsername(ValidationResults result) {
        if (StringUtils.isBlank((CharSequence)this.username)) {
            result.addResult(CredentialsField.USERNAME, new ValidationResult(ValidationResultEnum.ERROR, "No Hub Username was found."));
        }
    }

    public void validatePassword(ValidationResults result) {
        if (StringUtils.isBlank((CharSequence)this.password)) {
            result.addResult(CredentialsField.PASSWORD, new ValidationResult(ValidationResultEnum.ERROR, "No Hub Password was found."));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

