/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeCallable;
import com.synopsys.integration.phonehome.PhoneHomeResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class PhoneHomeService {
    private final IntLogger logger;
    private final ExecutorService executorService;

    public PhoneHomeService(IntLogger logger, ExecutorService executorService) {
        this.logger = logger;
        this.executorService = executorService;
    }

    public PhoneHomeResponse startPhoneHome(PhoneHomeCallable phoneHomeCallable) {
        try {
            Future<Boolean> resultTask = this.executorService.submit(phoneHomeCallable);
            return new PhoneHomeResponse(resultTask);
        }
        catch (Exception e) {
            this.logger.debug("Could not build phone home body" + e.getMessage(), e);
            return null;
        }
    }

    public Boolean phoneHome(PhoneHomeCallable phoneHomeCallable) {
        try {
            return phoneHomeCallable.call();
        }
        catch (Exception e) {
            this.logger.debug("Could not build phone home body" + e.getMessage(), e);
            return false;
        }
    }
}

