/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Forge {
    public static final Map<String, Forge> FORGE_NAME_TO_FORGE = new HashMap<String, Forge>();
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final String NUMBR = "#";
    private static final String COLON = ":";
    private static final String ATSGN = "@";
    private static final String EQUAL = "=";
    private static final String HYFEN = "-";
    public static final Forge ALPINE = Forge.createSlashSlashForge("alpine");
    public static final Forge APACHE_SOFTWARE = Forge.createSlashSlashForge("apache_software");
    public static final Forge BITBUCKET = Forge.createSlashSlashForge("bitbucket");
    public static final Forge BUSYBOX = Forge.createSlashSlashForge("busybox");
    public static final Forge CENTOS = Forge.createSlashSlashForge("centos");
    public static final Forge CODEPLEX = Forge.createSlashSlashForge("codeplex");
    public static final Forge CODEPLEX_GROUP = Forge.createSlashSlashForge("codeplex_group");
    public static final Forge CRAN = Forge.createSlashSlashForge("cran");
    public static final Forge DEBIAN = Forge.createSlashSlashForge("debian");
    public static final Forge FEDORA = Forge.createSlashSlashForge("fedora");
    public static final Forge FREEDESKTOP_ORG = Forge.createSlashSlashForge("freedesktop_org");
    public static final Forge GITCAFE = Forge.createSlashSlashForge("gitcafe");
    public static final Forge GITLAB = Forge.createSlashSlashForge("gitlab");
    public static final Forge GITORIOUS = Forge.createSlashSlashForge("gitorious");
    public static final Forge GNU = Forge.createSlashSlashForge("gnu");
    public static final Forge GOOGLECODE = Forge.createSlashSlashForge("googlecode");
    public static final Forge HEX = Forge.createSlashSlashForge("hex");
    public static final Forge JAVA_NET = Forge.createSlashSlashForge("java_net");
    public static final Forge KDE_ORG = Forge.createSlashSlashForge("kde_org");
    public static final Forge LAUNCHPAD = Forge.createSlashSlashForge("launchpad");
    public static final Forge LONG_TAIL = Forge.createSlashSlashForge("long_tail");
    public static final Forge NUGET = Forge.createSlashSlashForge("nuget");
    public static final Forge PEAR = Forge.createSlashSlashForge("pear");
    public static final Forge PYPI = Forge.createSlashSlashForge("pypi");
    public static final Forge REDHAT = Forge.createSlashSlashForge("redhat");
    public static final Forge RUBYFORGE = Forge.createSlashSlashForge("rubyforge");
    public static final Forge SOURCEFORGE = Forge.createSlashSlashForge("sourceforge");
    public static final Forge SOURCEFORGE_JP = Forge.createSlashSlashForge("sourceforge_jp");
    public static final Forge UBUNTU = Forge.createSlashSlashForge("ubuntu");
    public static final Forge ANDROID = Forge.createColonColonForge("android");
    public static final Forge COCOAPODS = Forge.createColonColonForge("cocoapods");
    public static final Forge CPE = Forge.createColonColonForge("cpe");
    public static final Forge GITHUB = Forge.createColonColonForge("github");
    public static final Forge GOLANG = Forge.createColonColonForge("golang");
    public static final Forge MAVEN = Forge.createColonColonForge("maven");
    public static final Forge PACKAGIST = Forge.createColonColonForge("packagist");
    public static final Forge ANACONDA = Forge.createEqualSlashForge("anaconda");
    public static final Forge RUBYGEMS = Forge.createEqualSlashForge("rubygems");
    public static final Forge BOWER = new Forge("#", "/", "bower");
    public static final Forge CPAN = new Forge("-", "/", "cpan");
    public static final Forge GOGET = new Forge("", "/", "goget");
    public static final Forge NPM = new Forge("@", "/", "npm");
    private final String name;
    private final String separator;
    private final String kbSeparator;

    private static final Forge createSlashSlashForge(String forgeName) {
        return new Forge(SLASH, SLASH, forgeName);
    }

    private static final Forge createColonColonForge(String forgeName) {
        return new Forge(COLON, COLON, forgeName);
    }

    private static final Forge createEqualSlashForge(String forgeName) {
        return new Forge(EQUAL, SLASH, forgeName);
    }

    public Forge(String separator, String kbSeparator, String name) {
        this.name = name;
        this.separator = separator;
        this.kbSeparator = kbSeparator;
        FORGE_NAME_TO_FORGE.put(name, this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getKbSeparator() {
        return this.kbSeparator;
    }
}

