/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.component.ProjectRequest;
import com.synopsys.integration.blackduck.api.generated.component.ProjectVersionRequest;
import com.synopsys.integration.blackduck.api.generated.response.AssignedUserGroupView;
import com.synopsys.integration.blackduck.api.generated.view.AssignedUserView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentSearchResultView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentVersionView;
import com.synopsys.integration.blackduck.api.generated.view.MatchedFileView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.UserGroupView;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomComponentView;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomPolicyStatusView;
import com.synopsys.integration.blackduck.api.generated.view.VulnerableComponentView;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.service.ComponentService;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.ProjectGetService;
import com.synopsys.integration.blackduck.service.ProjectUpdateService;
import com.synopsys.integration.blackduck.service.model.ComponentVersionVulnerabilities;
import com.synopsys.integration.blackduck.service.model.ProjectRequestBuilder;
import com.synopsys.integration.blackduck.service.model.ProjectVersionWrapper;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.blackduck.service.model.VersionBomComponentModel;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProjectService
extends DataService {
    private final ProjectGetService projectGetService;
    private final ProjectUpdateService projectUpdateService;
    private final ComponentService componentDataService;

    public ProjectService(HubService hubService, IntLogger logger, ProjectGetService projectGetService, ProjectUpdateService projectUpdateService, ComponentService componentDataService) {
        super(hubService, logger);
        this.projectGetService = projectGetService;
        this.projectUpdateService = projectUpdateService;
        this.componentDataService = componentDataService;
    }

    public List<ProjectView> getAllProjectMatches(String projectName) throws IntegrationException {
        return this.projectGetService.getAllProjectMatches(projectName);
    }

    public List<ProjectView> getProjectMatches(String projectName, int limit) throws IntegrationException {
        return this.projectGetService.getProjectMatches(projectName, limit);
    }

    public ProjectView getProjectByName(String projectName) throws IntegrationException {
        return this.projectGetService.getProjectByName(projectName);
    }

    public ProjectVersionView getProjectVersion(ProjectView project, String projectVersionName) throws IntegrationException {
        return this.projectGetService.getProjectVersion(project, projectVersionName);
    }

    public ProjectVersionWrapper getProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        return this.projectGetService.getProjectVersion(projectName, projectVersionName);
    }

    public List<AssignedUserView> getAssignedUsersToProject(String projectName) throws IntegrationException {
        ProjectView project = this.getProjectByName(projectName);
        return this.getAssignedUsersToProject(project);
    }

    public List<AssignedUserView> getAssignedUsersToProject(ProjectView project) throws IntegrationException {
        List<AssignedUserView> assignedUsers = this.hubService.getAllResponses(project, ProjectView.USERS_LINK_RESPONSE);
        return assignedUsers;
    }

    public List<UserView> getUsersForProject(String projectName) throws IntegrationException {
        ProjectView project = this.getProjectByName(projectName);
        return this.getUsersForProject(project);
    }

    public List<UserView> getUsersForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.name);
        List<AssignedUserView> assignedUsers = this.getAssignedUsersToProject(project);
        ArrayList<UserView> resolvedUserViews = new ArrayList<UserView>();
        for (AssignedUserView assigned : assignedUsers) {
            UserView userView = this.hubService.getResponse(assigned.user, UserView.class);
            if (userView == null) continue;
            resolvedUserViews.add(userView);
        }
        return resolvedUserViews;
    }

    public List<AssignedUserGroupView> getAssignedGroupsToProject(String projectName) throws IntegrationException {
        ProjectView project = this.getProjectByName(projectName);
        return this.getAssignedGroupsToProject(project);
    }

    public List<AssignedUserGroupView> getAssignedGroupsToProject(ProjectView project) throws IntegrationException {
        List<AssignedUserGroupView> assignedGroups = this.hubService.getAllResponses(project, ProjectView.USERGROUPS_LINK_RESPONSE);
        return assignedGroups;
    }

    public List<UserGroupView> getGroupsForProject(String projectName) throws IntegrationException {
        ProjectView project = this.getProjectByName(projectName);
        return this.getGroupsForProject(project);
    }

    public List<UserGroupView> getGroupsForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.name);
        List<AssignedUserGroupView> assignedGroups = this.getAssignedGroupsToProject(project);
        ArrayList<UserGroupView> resolvedGroupViews = new ArrayList<UserGroupView>();
        for (AssignedUserGroupView assigned : assignedGroups) {
            UserGroupView groupView = this.hubService.getResponse(assigned.group, UserGroupView.class);
            if (groupView == null) continue;
            resolvedGroupViews.add(groupView);
        }
        return resolvedGroupViews;
    }

    @Deprecated
    public Set<UserView> getAllActiveUsersForProject(String projectName) throws IntegrationException {
        ProjectView projectView = this.getProjectByName(projectName);
        return this.getAllActiveUsersForProject(projectView);
    }

    public Set<UserView> getAllActiveUsersForProject(ProjectView projectView) throws IntegrationException {
        HashSet<UserView> users = new HashSet<UserView>();
        List<AssignedUserGroupView> assignedGroups = this.getAssignedGroupsToProject(projectView);
        for (AssignedUserGroupView assignedUserGroupView : assignedGroups) {
            if (!assignedUserGroupView.active.booleanValue()) continue;
            UserGroupView userGroupView = this.hubService.getResponse(assignedUserGroupView.group, UserGroupView.class);
            if (!userGroupView.active.booleanValue()) continue;
            List<UserView> groupUsers = this.hubService.getAllResponses(userGroupView, UserGroupView.USERS_LINK_RESPONSE);
            users.addAll(groupUsers);
        }
        List<AssignedUserView> assignedUsers = this.getAssignedUsersToProject(projectView);
        for (AssignedUserView assignedUser : assignedUsers) {
            UserView userView2 = this.hubService.getResponse(assignedUser.user, UserView.class);
            users.add(userView2);
        }
        return users.stream().filter(userView -> userView.active).collect(Collectors.toSet());
    }

    public List<VersionBomComponentView> getComponentsForProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectItem = this.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.getProjectVersion(projectItem, projectVersionName);
        return this.getComponentsForProjectVersion(projectVersionView);
    }

    public List<VersionBomComponentView> getComponentsForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        List<VersionBomComponentView> versionBomComponentViews = this.hubService.getAllResponses(projectVersionView, ProjectVersionView.COMPONENTS_LINK_RESPONSE);
        return versionBomComponentViews;
    }

    public List<VulnerableComponentView> getVulnerableComponentsForProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectItem = this.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.getProjectVersion(projectItem, projectVersionName);
        return this.getVulnerableComponentsForProjectVersion(projectVersionView);
    }

    public List<VulnerableComponentView> getVulnerableComponentsForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        List<VulnerableComponentView> vulnerableBomComponentViews = this.hubService.getAllResponses(projectVersionView, ProjectVersionView.VULNERABLE_COMPONENTS_LINK_RESPONSE);
        return vulnerableBomComponentViews;
    }

    public List<ComponentVersionVulnerabilities> getComponentVersionVulnerabilities(ProjectVersionView projectVersionView) throws IntegrationException {
        List<VersionBomComponentView> versionBomComponentViews = this.getComponentsForProjectVersion(projectVersionView);
        ArrayList<ComponentVersionView> componentVersionViews = new ArrayList<ComponentVersionView>();
        for (VersionBomComponentView versionBomComponentView : versionBomComponentViews) {
            if (!StringUtils.isNotBlank((CharSequence)versionBomComponentView.componentVersion)) continue;
            ComponentVersionView componentVersionView = this.hubService.getResponse(versionBomComponentView.componentVersion, ComponentVersionView.class);
            componentVersionViews.add(componentVersionView);
        }
        ArrayList<ComponentVersionVulnerabilities> componentVersionVulnerabilitiesList = new ArrayList<ComponentVersionVulnerabilities>();
        for (ComponentVersionView componentVersionView : componentVersionViews) {
            ComponentVersionVulnerabilities componentVersionVulnerabilities = this.componentDataService.getComponentVersionVulnerabilities(componentVersionView);
            componentVersionVulnerabilitiesList.add(componentVersionVulnerabilities);
        }
        return componentVersionVulnerabilitiesList;
    }

    public List<ComponentVersionVulnerabilities> getComponentVersionVulnerabilities(String projectName, String projectVersionName) throws IntegrationException {
        ProjectVersionWrapper projectVersionWrapper = this.getProjectVersion(projectName, projectVersionName);
        ProjectVersionView projectVersionView = projectVersionWrapper.getProjectVersionView();
        return this.getComponentVersionVulnerabilities(projectVersionView);
    }

    public List<VersionBomComponentModel> getComponentsWithMatchedFilesForProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView project = this.getProjectByName(projectName);
        ProjectVersionView version = this.getProjectVersion(project, projectVersionName);
        return this.getComponentsWithMatchedFilesForProjectVersion(version);
    }

    public List<VersionBomComponentModel> getComponentsWithMatchedFilesForProjectVersion(ProjectVersionView version) throws IntegrationException {
        List<VersionBomComponentView> bomComponents = this.hubService.getAllResponses(version, ProjectVersionView.COMPONENTS_LINK_RESPONSE);
        ArrayList<VersionBomComponentModel> modelBomComponents = new ArrayList<VersionBomComponentModel>(bomComponents.size());
        for (VersionBomComponentView component : bomComponents) {
            modelBomComponents.add(new VersionBomComponentModel(component, this.getMatchedFiles(component)));
        }
        return modelBomComponents;
    }

    private List<MatchedFileView> getMatchedFiles(VersionBomComponentView component) throws IntegrationException {
        List<MatchedFileView> matchedFiles = new ArrayList<MatchedFileView>(0);
        List<MatchedFileView> tempMatchedFiles = this.hubService.getAllResponses(component, VersionBomComponentView.MATCHED_FILES_LINK_RESPONSE);
        if (tempMatchedFiles != null && tempMatchedFiles.isEmpty()) {
            matchedFiles = tempMatchedFiles;
        }
        return matchedFiles;
    }

    public VersionBomPolicyStatusView getPolicyStatusForProjectAndVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectItem = this.getProjectByName(projectName);
        List<ProjectVersionView> projectVersions = this.hubService.getAllResponses(projectItem, ProjectView.VERSIONS_LINK_RESPONSE);
        ProjectVersionView projectVersionView = this.findMatchingVersion(projectVersions, projectVersionName);
        return this.getPolicyStatusForVersion(projectVersionView);
    }

    public VersionBomPolicyStatusView getPolicyStatusForVersion(ProjectVersionView version) throws IntegrationException {
        return this.hubService.getResponse(version, ProjectVersionView.POLICY_STATUS_LINK_RESPONSE);
    }

    private ProjectVersionView findMatchingVersion(List<ProjectVersionView> projectVersions, String projectVersionName) throws HubIntegrationException {
        for (ProjectVersionView version : projectVersions) {
            if (!projectVersionName.equals(version.versionName)) continue;
            return version;
        }
        return null;
    }

    public String createHubProject(ProjectRequest projectRequest) throws IntegrationException {
        return this.projectUpdateService.createProject(projectRequest);
    }

    public void updateHubProject(String projectUrl, ProjectRequest projectRequest) throws IntegrationException {
        this.projectUpdateService.updateProject(projectUrl, projectRequest);
    }

    public void deleteHubProject(ProjectView project) throws IntegrationException {
        String projectUrl = this.hubService.getHref(project);
        this.projectUpdateService.deleteProject(projectUrl);
    }

    public String createHubVersion(ProjectView project, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        String projectVersionsUrl = this.hubService.getFirstLink(project, "versions");
        return this.projectUpdateService.createProjectVersion(projectVersionsUrl, projectVersionRequest);
    }

    public String createHubVersion(String projectVersionsUrl, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        return this.projectUpdateService.createProjectVersion(projectVersionsUrl, projectVersionRequest);
    }

    public void updateProjectVersion(ProjectVersionView version, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        String projectVersionUrl = this.hubService.getHref(version);
        this.projectUpdateService.updateProjectVersion(projectVersionUrl, projectVersionRequest);
    }

    public void updateProjectVersion(String projectVersionUrl, ProjectVersionRequest projectVersionRequest) throws IntegrationException {
        this.projectUpdateService.updateProjectVersion(projectVersionUrl, projectVersionRequest);
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectRequest projectRequest) throws IntegrationException {
        return this.projectUpdateService.syncProjectAndVersion(projectRequest);
    }

    public ProjectVersionWrapper syncProjectAndVersion(ProjectRequest projectRequest, boolean performUpdate) throws IntegrationException {
        return this.projectUpdateService.syncProjectAndVersion(projectRequest, performUpdate);
    }

    @Deprecated
    public ProjectVersionWrapper getProjectVersionAndCreateIfNeeded(String projectName, String projectVersionName) throws IntegrationException {
        ProjectRequest projectRequest = (ProjectRequest)new ProjectRequestBuilder(projectName, projectVersionName).build();
        return this.getProjectVersionAndCreateIfNeeded(projectRequest);
    }

    @Deprecated
    public ProjectVersionWrapper getProjectVersionAndCreateIfNeeded(ProjectRequest projectRequest) throws IntegrationException {
        ProjectView project = null;
        ProjectVersionView projectVersion = null;
        try {
            project = this.getProjectByName(projectRequest.name);
        }
        catch (DoesNotExistException e) {
            String projectURL = this.createHubProject(projectRequest);
            project = this.hubService.getResponse(projectURL, ProjectView.class);
        }
        try {
            projectVersion = this.getProjectVersion(project, projectRequest.versionRequest.versionName);
        }
        catch (DoesNotExistException e) {
            String versionURL = this.createHubVersion(project, projectRequest.versionRequest);
            projectVersion = this.hubService.getResponse(versionURL, ProjectVersionView.class);
        }
        return new ProjectVersionWrapper(project, projectVersion);
    }

    public void updateProjectAndVersion(String projectUri, ProjectRequest projectRequest) throws IntegrationException {
        this.updateProjectAndVersion(this.hubService.getResponse(projectUri, ProjectView.class), projectRequest);
    }

    public void updateProjectAndVersion(ProjectView project, ProjectRequest projectRequest) throws IntegrationException {
        ProjectVersionView projectVersionView;
        String projectUrl = this.hubService.getHref(project);
        this.projectUpdateService.updateProject(projectUrl, projectRequest);
        if (null != projectRequest.versionRequest && StringUtils.isNotBlank((CharSequence)projectRequest.versionRequest.versionName) && null != (projectVersionView = this.getProjectVersion(project, projectRequest.versionRequest.versionName))) {
            this.updateProjectVersion(projectVersionView, projectRequest.versionRequest);
        }
    }

    public void updateProjectAndVersion(ProjectView project, ProjectVersionView projectVersion, ProjectRequest projectRequest) throws IntegrationException {
        String projectUrl = this.hubService.getHref(project);
        String projectVersionUrl = this.hubService.getHref(projectVersion);
        this.updateProjectAndVersion(projectUrl, projectVersionUrl, projectRequest);
    }

    public void updateProjectAndVersion(String projectUrl, String projectVersionUri, ProjectRequest projectRequest) throws IntegrationException {
        this.projectUpdateService.updateProject(projectUrl, projectRequest);
        this.updateProjectVersion(projectVersionUri, projectRequest.versionRequest);
    }

    public void addComponentToProjectVersion(ExternalId componentExternalId, String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectView = this.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.getProjectVersion(projectView, projectVersionName);
        this.addComponentToProjectVersion(componentExternalId, projectVersionView);
    }

    public void addComponentToProjectVersion(ExternalId componentExternalId, ProjectVersionView projectVersionView) throws IntegrationException {
        String projectVersionComponentsUrl = this.hubService.getFirstLink(projectVersionView, "components");
        ComponentSearchResultView componentSearchResultView = this.componentDataService.getExactComponentMatch(componentExternalId);
        String componentVersionUrl = null;
        componentVersionUrl = StringUtils.isNotBlank((CharSequence)componentSearchResultView.variant) ? componentSearchResultView.variant : componentSearchResultView.version;
        this.addComponentToProjectVersion("application/json", projectVersionComponentsUrl, componentVersionUrl);
    }

    public void addComponentToProjectVersion(String mediaType, String projectVersionComponentsUri, String componentVersionUrl) throws IntegrationException {
        Request request = RequestFactory.createCommonPostRequestBuilder("{\"component\": \"" + componentVersionUrl + "\"}").uri(projectVersionComponentsUri).mimeType(mediaType).build();
        try {
            Response response = this.hubService.executeRequest(request);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }
}

