/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.PolicyRuleViewV2;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.body.StringBodyContent;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.util.List;

public class PolicyRuleService {
    private final HubService hubService;

    public PolicyRuleService(HubService hubService) {
        this.hubService = hubService;
    }

    public PolicyRuleViewV2 getPolicyRuleViewByName(String policyRuleName) throws IntegrationException {
        List<PolicyRuleViewV2> allPolicyRules = this.hubService.getAllResponses(ApiDiscovery.POLICY_RULES_LINK_RESPONSE);
        for (PolicyRuleViewV2 policyRule : allPolicyRules) {
            if (!policyRuleName.equals(policyRule.name)) continue;
            return policyRule;
        }
        throw new DoesNotExistException("This Policy Rule does not exist: " + policyRuleName);
    }

    public String createPolicyRule(PolicyRuleViewV2 policyRuleViewV2) throws IntegrationException {
        String json = this.hubService.convertToJson(policyRuleViewV2);
        Request.Builder requestBuilder = RequestFactory.createCommonPostRequestBuilder(json);
        return this.hubService.executePostRequestAndRetrieveURL(ApiDiscovery.POLICY_RULES_LINK, requestBuilder);
    }

    public void updatePolicyRule(PolicyRuleViewV2 policyRuleView) throws IntegrationException {
        String json = this.hubService.convertToJson(policyRuleView);
        Request.Builder requestBuilder = new Request.Builder().method(HttpMethod.PUT).bodyContent(new StringBodyContent(json)).uri(this.hubService.getHref(policyRuleView));
        try {
            Response response = this.hubService.executeRequest(requestBuilder.build());
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public void deletePolicyRule(PolicyRuleViewV2 policyRuleView) throws IntegrationException {
        Request.Builder requestBuilder = new Request.Builder().method(HttpMethod.DELETE).uri(this.hubService.getHref(policyRuleView));
        try {
            Response response = this.hubService.executeRequest(requestBuilder.build());
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }
}

