/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.rest;

import com.synopsys.integration.blackduck.rest.CredentialsRestConnection;
import com.synopsys.integration.blackduck.validator.CredentialsRestConnectionValidator;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.rest.connection.AbstractRestConnectionBuilder;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.validator.AbstractValidator;

public class CredentialsRestConnectionBuilder
extends AbstractRestConnectionBuilder<CredentialsRestConnection> {
    private String username;
    private String password;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void applyCredentials(Credentials credentials) {
        try {
            this.setUsername(credentials.getUsername());
            this.setPassword(credentials.getDecryptedPassword());
        }
        catch (EncryptionException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public AbstractValidator createValidator() {
        CredentialsRestConnectionValidator validator = new CredentialsRestConnectionValidator();
        validator.setBaseUrl(this.getBaseUrl());
        validator.setTimeout(this.getTimeout());
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        validator.setProxyHost(this.getProxyHost());
        validator.setProxyPort(this.getProxyPort());
        validator.setProxyUsername(this.getProxyUsername());
        validator.setProxyPassword(this.getProxyPassword());
        validator.setProxyIgnoreHosts(this.getProxyIgnoreHosts());
        validator.setProxyNtlmDomain(this.getProxyNtlmDomain());
        validator.setProxyNtlmWorkstation(this.getProxyNtlmWorkstation());
        validator.setLogger(this.getLogger());
        validator.setCommonRequestHeaders(this.getCommonRequestHeaders());
        return validator;
    }

    @Override
    public CredentialsRestConnection createConnection(ProxyInfo proxyInfo) {
        CredentialsRestConnection connection = new CredentialsRestConnection(this.getLogger(), this.getBaseConnectionUrl(), this.getUsername(), this.getPassword(), this.getTimeout(), proxyInfo);
        return connection;
    }
}

