#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from blackduck.hub_services_helper import HubServicesHelper
from com.synopsys.integration.blackduck.exception import DoesNotExistException

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")

hub_services_helper = HubServicesHelper(params=blackduckServer)

try:
    risk_profile_view, project_view, version_view = hub_services_helper.get_risk_profile(projectName, version)
    riskTypeFields = {
        'Security Risks': 'VULNERABILITY',
        'Operational Risks': 'OPERATIONAL',
        'License Risks': 'LICENSE'
    }

    counts = risk_profile_view.categories.get(riskTypeFields[riskType])
    data = {
        'riskProfile': counts,
        'projectName': projectName,
        'projectVersion': version,
        'projectVersionURL': hub_services_helper.get_project_version_url_by_id(hub_services_helper.get_project_version_id_by_view(version_view)),
        'projectURL': hub_services_helper.get_project_url(project_view),
        'riskType': riskType,
        'lastUpdatedAt': risk_profile_view.bomLastUpdatedAt
    }
except DoesNotExistException as exception:
    data = {'error': exception.message}

