/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.blackduck;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.blackduck.configuration.HubServerConfigBuilder;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.rest.CredentialsRestConnection;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.HubServicesFactory;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.log.PrintStreamIntLogger;
import com.xebialabs.xlrelease.plugin.blackduck.HubCompositeService;

public class RestConnectionHelper {
    private String hubServerUrl;
    private String username;
    private String password;
    private boolean trustCertificate;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public RestConnectionHelper(String hubServerUrl, String username, String password, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, Boolean trustCertificate) {
        this.hubServerUrl = hubServerUrl;
        this.username = username;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.trustCertificate = trustCertificate;
    }

    public HubServerConfig getHubServerConfig() {
        HubServerConfigBuilder builder = new HubServerConfigBuilder();
        builder.setUrl(this.hubServerUrl);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        builder.setProxyHost(this.proxyHost);
        builder.setProxyPort(this.proxyPort);
        builder.setProxyUsername(this.proxyUsername);
        builder.setProxyPassword(this.proxyPassword);
        builder.setTrustCert(this.trustCertificate);
        return builder.build();
    }

    public CredentialsRestConnection getIntegrationHubRestConnection() throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.getRestConnection(this.getHubServerConfig());
    }

    public CredentialsRestConnection getRestConnection(HubServerConfig serverConfig) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.getRestConnection(serverConfig, LogLevel.INFO);
    }

    public CredentialsRestConnection getRestConnection(HubServerConfig serverConfig, LogLevel logLevel) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return serverConfig.createCredentialsRestConnection(new PrintStreamIntLogger(System.out, logLevel));
    }

    public HubServicesFactory createHubServicesFactory() throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.createHubServicesFactory(LogLevel.INFO);
    }

    public HubServicesFactory createHubServicesFactory(LogLevel logLevel) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.createHubServicesFactory(this.createIntLogger(logLevel));
    }

    public IntLogger createIntLogger(LogLevel logLevel) {
        return new PrintStreamIntLogger(System.out, logLevel);
    }

    public HubServicesFactory createHubServicesFactory(IntLogger logger) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        CredentialsRestConnection restConnection = this.getIntegrationHubRestConnection();
        HubServicesFactory hubServicesFactory = new HubServicesFactory(HubServicesFactory.createDefaultGson(), HubServicesFactory.createDefaultJsonParser(), restConnection, logger);
        return hubServicesFactory;
    }

    public HubCompositeService createHubCompositeService() throws HubIntegrationException, EncryptionException {
        HubServicesFactory hubServicesFactory = this.createHubServicesFactory();
        HubService hubService = hubServicesFactory.createHubService();
        return new HubCompositeService(hubService, hubServicesFactory.getLogger());
    }
}

