/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.connection;

import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public abstract class RestConnection
implements Closeable {
    public static final String ERROR_MSG_PROXY_INFO_NULL = "A RestConnection's proxy information cannot be null";
    protected final IntLogger logger;
    private final URL baseUrl;
    private int timeout = 120;
    private final ProxyInfo proxyInfo;
    private final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private final HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    private final RequestConfig.Builder defaultRequestConfigBuilder = RequestConfig.custom();
    private final Map<String, String> commonRequestHeaders = new HashMap<String, String>();
    private boolean alwaysTrustServerCertificate;
    private CloseableHttpClient client;

    public RestConnection(IntLogger logger, URL baseUrl, ProxyInfo proxyInfo) {
        this.logger = logger;
        this.baseUrl = baseUrl;
        this.proxyInfo = proxyInfo;
    }

    public RestConnection(IntLogger logger, URL baseUrl, int timeout, ProxyInfo proxyInfo) {
        this(logger, baseUrl, proxyInfo);
        this.timeout = timeout;
    }

    public void connect() throws IntegrationException {
        this.addBuilderConnectionTimes();
        this.addBuilderProxyInformation();
        this.populateHttpClientBuilder(this.clientBuilder, this.defaultRequestConfigBuilder);
        this.assembleClient();
        this.setClient(this.clientBuilder.build());
        this.completeConnection();
    }

    public abstract void populateHttpClientBuilder(HttpClientBuilder var1, RequestConfig.Builder var2) throws IntegrationException;

    public abstract void completeConnection() throws IntegrationException;

    public RequestBuilder createRequestBuilder(HttpMethod method) throws IntegrationException {
        return this.createRequestBuilder(method, null);
    }

    public RequestBuilder createRequestBuilder(HttpMethod method, Map<String, String> additionalHeaders) throws IntegrationException {
        if (method == null) {
            throw new IntegrationException("Missing field 'method'");
        }
        RequestBuilder requestBuilder = RequestBuilder.create(method.name());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(this.commonRequestHeaders);
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            requestHeaders.putAll(additionalHeaders);
        }
        for (Map.Entry header : requestHeaders.entrySet()) {
            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        if (this.baseUrl != null) {
            try {
                requestBuilder.setUri(this.baseUrl.toURI());
            }
            catch (URISyntaxException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
        return requestBuilder;
    }

    public HttpUriRequest createHttpRequest(Request request) throws IntegrationException {
        if (request == null) {
            throw new IntegrationException("Missing the Request");
        }
        if (request.getMethod() == null) {
            throw new IntegrationException("Missing the HttpMethod");
        }
        try {
            Map<String, Set<String>> populatedQueryParameters;
            URIBuilder uriBuilder;
            if (StringUtils.isNotBlank((CharSequence)request.getUri())) {
                uriBuilder = new URIBuilder(request.getUri());
            } else if (this.baseUrl != null) {
                uriBuilder = new URIBuilder(this.baseUrl.toURI());
            } else {
                throw new IntegrationException("Missing the URI");
            }
            String mimeType = ContentType.APPLICATION_JSON.getMimeType();
            Charset bodyEncoding = Charsets.UTF_8;
            if (StringUtils.isNotBlank((CharSequence)request.getMimeType())) {
                mimeType = request.getMimeType();
            }
            if (request.getBodyEncoding() != null) {
                bodyEncoding = request.getBodyEncoding();
            }
            RequestBuilder requestBuilder = RequestBuilder.create(request.getMethod().name());
            if (HttpMethod.GET == request.getMethod() && (request.getAdditionalHeaders() == null || request.getAdditionalHeaders().isEmpty() || !request.getAdditionalHeaders().containsKey("Accept"))) {
                requestBuilder.addHeader("Accept", mimeType);
            }
            requestBuilder.setCharset(bodyEncoding);
            if (request.getAdditionalHeaders() != null && !request.getAdditionalHeaders().isEmpty()) {
                for (Map.Entry<String, String> header : request.getAdditionalHeaders().entrySet()) {
                    requestBuilder.addHeader(header.getKey(), header.getValue());
                }
            }
            if (this.commonRequestHeaders != null && !this.commonRequestHeaders.isEmpty()) {
                for (Map.Entry<String, String> header : this.commonRequestHeaders.entrySet()) {
                    requestBuilder.addHeader(header.getKey(), header.getValue());
                }
            }
            if (!(populatedQueryParameters = request.getPopulatedQueryParameters()).isEmpty()) {
                populatedQueryParameters.forEach((paramKey, paramValues) -> paramValues.forEach(paramValue -> uriBuilder.addParameter((String)paramKey, (String)paramValue)));
            }
            requestBuilder.setUri(uriBuilder.build());
            HttpEntity entity = request.createHttpEntity();
            if (entity != null) {
                requestBuilder.setEntity(entity);
            }
            return requestBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public HttpUriRequest copyHttpRequest(HttpUriRequest request) throws IntegrationException {
        RequestBuilder requestBuilder = RequestBuilder.copy(request);
        if (this.commonRequestHeaders != null && !this.commonRequestHeaders.isEmpty()) {
            for (Map.Entry<String, String> header : this.commonRequestHeaders.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return requestBuilder.build();
    }

    public Response executeRequest(Request request) throws IntegrationException {
        return this.executeRequest(this.createHttpRequest(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeRequest(HttpUriRequest request) throws IntegrationException {
        Response response;
        long start = System.currentTimeMillis();
        this.logMessage(LogLevel.TRACE, "starting request: " + request.getURI().toString());
        try {
            response = this.handleClientExecution(request, 0);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.logMessage(LogLevel.TRACE, String.format("completed request: %s (%d ms)", request.getURI().toString(), end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.logMessage(LogLevel.TRACE, String.format("completed request: %s (%d ms)", request.getURI().toString(), end - start));
        return response;
    }

    public Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck) throws IntegrationException, IOException {
        Request headRequest = new Request.Builder(getRequest).method(HttpMethod.HEAD).build();
        long lastModifiedOnServer = 0L;
        try (Response headResponse = this.executeRequest(headRequest);){
            lastModifiedOnServer = headResponse.getLastModified();
            this.logger.debug(String.format("Last modified on server: %d", lastModifiedOnServer));
        }
        catch (IntegrationException e) {
            this.logger.error("Couldn't get the Last-Modified header from the server.");
            throw e;
        }
        if (lastModifiedOnServer == timeToCheck) {
            this.logger.debug("The request has not been modified since it was last checked - skipping.");
            return Optional.empty();
        }
        return Optional.of(this.executeRequest(getRequest));
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.close();
        }
    }

    protected void logRequestHeaders(HttpUriRequest request) {
        if (this.isDebugLogging()) {
            String requestName = request.getClass().getSimpleName();
            this.logMessage(LogLevel.TRACE, requestName + " : " + request.toString());
            this.logHeaders(requestName, request.getAllHeaders());
        }
    }

    protected void logResponseHeaders(HttpResponse response) {
        if (this.isDebugLogging()) {
            String responseName = response.getClass().getSimpleName();
            this.logMessage(LogLevel.TRACE, responseName + " : " + response.toString());
            this.logHeaders(responseName, response.getAllHeaders());
        }
    }

    private void addBuilderConnectionTimes() {
        this.defaultRequestConfigBuilder.setConnectTimeout(this.timeout * 1000);
        this.defaultRequestConfigBuilder.setSocketTimeout(this.timeout * 1000);
        this.defaultRequestConfigBuilder.setConnectionRequestTimeout(this.timeout * 1000);
    }

    private void assembleClient() throws IntegrationException {
        try {
            this.clientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
            this.clientBuilder.setDefaultRequestConfig(this.defaultRequestConfigBuilder.build());
            SSLContext sslContext = null;
            sslContext = this.alwaysTrustServerCertificate ? SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build() : SSLContexts.createDefault();
            NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
            SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
            this.clientBuilder.setSSLSocketFactory(connectionFactory);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private void addBuilderProxyInformation() throws IntegrationException {
        if (this.proxyInfo == null) {
            throw new IllegalStateException(ERROR_MSG_PROXY_INFO_NULL);
        }
        if (this.proxyInfo.shouldUseProxyForUrl(this.baseUrl)) {
            this.defaultRequestConfigBuilder.setProxy(this.getProxyHttpHost());
            try {
                this.addProxyCredentials();
            }
            catch (EncryptionException | IllegalArgumentException ex) {
                throw new IntegrationException(ex);
            }
        }
    }

    private HttpHost getProxyHttpHost() {
        HttpHost httpHost = new HttpHost(this.proxyInfo.getHost(), this.proxyInfo.getPort());
        return httpHost;
    }

    private void addProxyCredentials() throws IntegrationException {
        if (this.proxyInfo.hasAuthenticatedProxySettings()) {
            NTCredentials creds = new NTCredentials(this.proxyInfo.getUsername(), this.proxyInfo.getDecryptedPassword(), this.proxyInfo.getNtlmWorkstation(), this.proxyInfo.getNtlmDomain());
            this.credentialsProvider.setCredentials(new AuthScope(this.proxyInfo.getHost(), this.proxyInfo.getPort()), creds);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response handleClientExecution(HttpUriRequest request, int retryCount) throws IntegrationException {
        if (this.client == null) {
            this.connect();
            HttpUriRequest newRequest = this.copyHttpRequest(request);
            return this.handleClientExecution(newRequest, retryCount);
        }
        try {
            URI uri = request.getURI();
            String urlString = request.getURI().toString();
            if (this.alwaysTrustServerCertificate && uri.getScheme().equalsIgnoreCase("https") && this.logger != null) {
                this.logger.debug("Automatically trusting the certificate for " + urlString);
            }
            this.logRequestHeaders(request);
            CloseableHttpResponse response = this.client.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            String statusMessage = response.getStatusLine().getReasonPhrase();
            if (statusCode >= 200 && statusCode < 300) {
                this.logResponseHeaders(response);
                return new Response(response);
            }
            try {
                if (statusCode == 401 && retryCount < 2) {
                    this.connect();
                    HttpUriRequest newRequest = this.copyHttpRequest(request);
                    Response response2 = this.handleClientExecution(newRequest, retryCount + 1);
                    return response2;
                }
                throw new IntegrationRestException(statusCode, statusMessage, String.format("There was a problem trying to %s this item: %s. Error: %s %s", request.getMethod(), urlString, statusCode, statusMessage));
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private void logMessage(LogLevel level, String txt) {
        if (this.logger != null) {
            if (level == LogLevel.ERROR) {
                this.logger.error(txt);
            } else if (level == LogLevel.WARN) {
                this.logger.warn(txt);
            } else if (level == LogLevel.INFO) {
                this.logger.info(txt);
            } else if (level == LogLevel.DEBUG) {
                this.logger.debug(txt);
            } else if (level == LogLevel.TRACE) {
                this.logger.trace(txt);
            }
        }
    }

    private boolean isDebugLogging() {
        return this.logger != null && this.logger.getLogLevel() == LogLevel.TRACE;
    }

    private void logHeaders(String requestOrResponseName, Header[] headers) {
        if (headers != null && headers.length > 0) {
            this.logMessage(LogLevel.TRACE, requestOrResponseName + " headers : ");
            for (Header header : headers) {
                this.logMessage(LogLevel.TRACE, String.format("Header %s : %s", header.getName(), header.getValue()));
            }
        } else {
            this.logMessage(LogLevel.TRACE, requestOrResponseName + " does not have any headers.");
        }
    }

    public String toString() {
        return "RestConnection [baseUrl=" + this.baseUrl + "]";
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public RequestConfig.Builder getDefaultRequestConfigBuilder() {
        return this.defaultRequestConfigBuilder;
    }

    public Map<String, String> getCommonRequestHeaders() {
        return this.commonRequestHeaders;
    }

    public void addCommonRequestHeader(String key, String value) {
        this.commonRequestHeaders.put(key, value);
    }

    public void addCommonRequestHeaders(Map<String, String> commonRequestHeaders) {
        commonRequestHeaders.putAll(commonRequestHeaders);
    }
}

