/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.connection;

import com.synopsys.integration.builder.AbstractBuilder;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.connection.RestConnection;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.proxy.ProxyInfoBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRestConnectionBuilder<C extends RestConnection>
extends AbstractBuilder<C> {
    private String baseUrl;
    private int timeout = 120;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyIgnoreHosts;
    private String proxyNtlmDomain;
    private String proxyNtlmWorkstation;
    private IntLogger logger;
    private boolean alwaysTrustServerCertificate;
    private Map<String, String> commonRequestHeaders = new HashMap<String, String>();

    @Override
    public C buildObject() {
        ProxyInfo proxyInfo = this.getProxyInfo();
        C connection = this.createConnection(proxyInfo);
        ((RestConnection)connection).setAlwaysTrustServerCertificate(this.alwaysTrustServerCertificate);
        if (!this.commonRequestHeaders.isEmpty()) {
            ((RestConnection)connection).getCommonRequestHeaders().putAll(this.commonRequestHeaders);
        }
        return connection;
    }

    public abstract C createConnection(ProxyInfo var1);

    private ProxyInfo getProxyInfo() {
        ProxyInfoBuilder builder = new ProxyInfoBuilder();
        builder.setHost(this.proxyHost);
        builder.setPort(this.proxyPort);
        builder.setUsername(this.proxyUsername);
        builder.setPassword(this.proxyPassword);
        builder.setIgnoredProxyHosts(this.proxyIgnoreHosts);
        builder.setNtlmDomain(this.proxyNtlmDomain);
        builder.setNtlmWorkstation(this.proxyNtlmWorkstation);
        return builder.buildObject();
    }

    public void applyHeader(String headerName, String headerValue) {
        this.commonRequestHeaders.put(headerName, headerValue);
    }

    public void applyProxyInfo(ProxyInfo proxyInfo) {
        try {
            this.setProxyHost(proxyInfo.getHost());
            this.setProxyPort(proxyInfo.getPort());
            this.setProxyUsername(proxyInfo.getUsername());
            this.setProxyPassword(proxyInfo.getDecryptedPassword());
            this.setProxyIgnoreHosts(proxyInfo.getIgnoredProxyHosts());
            this.setProxyNtlmDomain(proxyInfo.getNtlmDomain());
            this.setProxyNtlmWorkstation(proxyInfo.getNtlmWorkstation());
        }
        catch (EncryptionException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public URL getBaseConnectionUrl() {
        try {
            return new URL(this.baseUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyIgnoreHosts() {
        return this.proxyIgnoreHosts;
    }

    public void setProxyIgnoreHosts(String proxyIgnoreHosts) {
        this.proxyIgnoreHosts = proxyIgnoreHosts;
    }

    public String getProxyNtlmDomain() {
        return this.proxyNtlmDomain;
    }

    public void setProxyNtlmDomain(String proxyNtlmDomain) {
        this.proxyNtlmDomain = proxyNtlmDomain;
    }

    public String getProxyNtlmWorkstation() {
        return this.proxyNtlmWorkstation;
    }

    public void setProxyNtlmWorkstation(String proxyNtlmWorkstation) {
        this.proxyNtlmWorkstation = proxyNtlmWorkstation;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public void setLogger(IntLogger logger) {
        this.logger = logger;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public Map<String, String> getCommonRequestHeaders() {
        return this.commonRequestHeaders;
    }

    public void setCommonRequestHeaders(Map<String, String> commonRequestHeaders) {
        this.commonRequestHeaders = commonRequestHeaders;
    }
}

