/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.model.externalid;

import com.synopsys.integration.hub.bdio.model.Forge;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;

public class ExternalIdFactory {
    public ExternalId createNameVersionExternalId(Forge forge, String name, String version) {
        ExternalId externalId = new ExternalId(forge);
        externalId.name = name;
        externalId.version = version;
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createMavenExternalId(String group, String name, String version) {
        ExternalId externalId = this.createNameVersionExternalId(Forge.MAVEN, name, version);
        externalId.group = group;
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createArchitectureExternalId(Forge forge, String name, String version, String architecture) {
        ExternalId externalId = this.createNameVersionExternalId(forge, name, version);
        externalId.architecture = architecture;
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createModuleNamesExternalId(Forge forge, String ... moduleNames) {
        ExternalId externalId = new ExternalId(forge);
        externalId.moduleNames = moduleNames;
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createPathExternalId(Forge forge, String path) {
        ExternalId externalId = new ExternalId(forge);
        externalId.path = path;
        this.checkForValidity(externalId);
        return externalId;
    }

    private void checkForValidity(ExternalId externalId) {
        externalId.createBdioId();
    }
}

