/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.graph.builder;

import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.graph.MutableMapDependencyGraph;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.dependencyid.DependencyId;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyExternalIdDependencyGraphBuilder {
    private final Set<DependencyId> rootDependencyIds = new HashSet<DependencyId>();
    private final Map<DependencyId, LazyDependencyInfo> dependencyInfo = new HashMap<DependencyId, LazyDependencyInfo>();

    private LazyDependencyInfo infoForId(DependencyId id) {
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        if (info.aliasId != null) {
            info = this.dependencyInfo.get(info.aliasId);
        }
        return info;
    }

    public DependencyGraph build() {
        LazyDependencyInfo lazyDependencyInfo;
        MutableMapDependencyGraph mutableDependencyGraph = new MutableMapDependencyGraph();
        for (DependencyId dependencyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(dependencyId);
            if (lazyDependencyInfo.externalId != null) continue;
            throw new IllegalStateException(String.format("A dependency (%s) in a relationship in the graph never had it's external id set.", dependencyId.toString()));
        }
        for (DependencyId dependencyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(dependencyId);
            Dependency dependency = new Dependency(lazyDependencyInfo.name, lazyDependencyInfo.version, lazyDependencyInfo.externalId);
            for (DependencyId child : lazyDependencyInfo.children) {
                LazyDependencyInfo childInfo = this.infoForId(child);
                mutableDependencyGraph.addParentWithChild(dependency, new Dependency(childInfo.name, childInfo.version, childInfo.externalId));
            }
            if (!this.rootDependencyIds.contains(dependencyId) && !this.rootDependencyIds.contains(lazyDependencyInfo.aliasId)) continue;
            mutableDependencyGraph.addChildToRoot(dependency);
        }
        return mutableDependencyGraph;
    }

    private void ensureDependencyInfoExists(DependencyId dependencyId) {
        if (!this.dependencyInfo.containsKey(dependencyId)) {
            this.dependencyInfo.put(dependencyId, new LazyDependencyInfo());
        }
    }

    public void setDependencyAsAlias(DependencyId realDependencyId, DependencyId fakeDependencyId) {
        this.ensureDependencyInfoExists(realDependencyId);
        this.ensureDependencyInfoExists(fakeDependencyId);
        LazyDependencyInfo info = this.dependencyInfo.get(fakeDependencyId);
        info.aliasId = realDependencyId;
    }

    public void setDependencyInfo(DependencyId id, String name, String version, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.name = name;
        info.version = version;
        info.externalId = externalId;
    }

    public void setDependencyName(DependencyId id, String name) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.name = name;
    }

    public void setDependencyVersion(DependencyId id, String version) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.version = version;
    }

    public void setDependencyExternalId(DependencyId id, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get(id);
        info.externalId = externalId;
    }

    public void addParentWithChild(DependencyId parent, DependencyId child) {
        this.ensureDependencyInfoExists(child);
        this.ensureDependencyInfoExists(parent);
        this.dependencyInfo.get((Object)parent).children.add(child);
    }

    public void addParentWithChildren(DependencyId parent, List<DependencyId> children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(DependencyId parent, Set<DependencyId> children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(DependencyId parent, DependencyId ... children) {
        for (DependencyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addChildWithParent(DependencyId child, DependencyId parent) {
        this.ensureDependencyInfoExists(child);
        this.ensureDependencyInfoExists(parent);
        this.dependencyInfo.get((Object)parent).children.add(child);
    }

    public void addChildWithParents(DependencyId child, List<DependencyId> parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(DependencyId child, Set<DependencyId> parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(DependencyId child, DependencyId ... parents) {
        for (DependencyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildToRoot(DependencyId child) {
        this.ensureDependencyInfoExists(child);
        this.rootDependencyIds.add(child);
    }

    public void addChildrenToRoot(List<DependencyId> children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(Set<DependencyId> children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(DependencyId ... children) {
        for (DependencyId child : children) {
            this.addChildToRoot(child);
        }
    }

    private class LazyDependencyInfo {
        public Set<DependencyId> children = new HashSet<DependencyId>();
        public DependencyId aliasId;
        public ExternalId externalId;
        public String name;
        public String version;

        private LazyDependencyInfo() {
        }
    }
}

