/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.exception.ScanFailedException;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommandCallable;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommandOutput;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ScanCommandRunner {
    private final IntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final ScanPathsUtility scanPathsUtility;
    private final Optional<ExecutorService> optionalExecutorService;

    public ScanCommandRunner(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, ScanPathsUtility scanPathsUtility) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.scanPathsUtility = scanPathsUtility;
        this.optionalExecutorService = Optional.empty();
    }

    public ScanCommandRunner(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, ScanPathsUtility scanPathsUtility, ExecutorService executorService) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.scanPathsUtility = scanPathsUtility;
        this.optionalExecutorService = Optional.of(executorService);
    }

    public List<ScanCommandOutput> executeScans(List<ScanCommand> scanCommands, boolean cleanupOutput) throws ScanFailedException {
        this.logger.info("Starting the Black Duck Signature Scan commands.");
        List<ScanCommandOutput> scanCommandOutputs = this.executeCommands(scanCommands, cleanupOutput);
        this.logger.info("Completed the Black Duck Signature Scan commands.");
        return scanCommandOutputs;
    }

    private List<ScanCommandOutput> executeCommands(List<ScanCommand> scanCommands, boolean cleanupOutput) throws ScanFailedException {
        ArrayList<ScanCommandOutput> scanCommandOutputs = new ArrayList<ScanCommandOutput>();
        try {
            List<ScanCommandCallable> callables = this.createCallables(scanCommands, cleanupOutput);
            if (this.optionalExecutorService.isPresent()) {
                ExecutorService executorService = this.optionalExecutorService.get();
                ArrayList<Future<ScanCommandOutput>> submitted = new ArrayList<Future<ScanCommandOutput>>();
                for (ScanCommandCallable scanCommandCallable : callables) {
                    submitted.add(executorService.submit(scanCommandCallable));
                }
                for (Future future : submitted) {
                    ScanCommandOutput scanCommandOutput = (ScanCommandOutput)future.get();
                    if (scanCommandOutput == null) continue;
                    scanCommandOutputs.add(scanCommandOutput);
                }
            } else {
                for (ScanCommandCallable callable : callables) {
                    scanCommandOutputs.add(callable.call());
                }
            }
        }
        catch (Exception e) {
            throw new ScanFailedException(String.format("Encountered a problem waiting for a scan to finish. %s", e.getMessage()), e);
        }
        return scanCommandOutputs;
    }

    private List<ScanCommandCallable> createCallables(List<ScanCommand> scanCommands, boolean cleanupOutput) {
        List<ScanCommandCallable> callables = scanCommands.stream().map(scanCommand -> new ScanCommandCallable(this.logger, this.scanPathsUtility, this.intEnvironmentVariables, (ScanCommand)scanCommand, cleanupOutput)).collect(Collectors.toList());
        return callables;
    }
}

