/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.summary.Result;
import com.synopsys.integration.log.IntLogger;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

public class ScanCommandOutput {
    public static final String DRY_RUN_RESULT_DIRECTORY = "data";
    public static final String SCAN_RESULT_DIRECTORY = "status";
    private final IntLogger logger;
    private final Result result;
    private final String errorMessage;
    private final Exception exception;
    private final ScanCommand scanCommand;

    public static ScanCommandOutput SUCCESS(IntLogger logger, ScanCommand scanCommand) {
        return new ScanCommandOutput(logger, scanCommand, Result.SUCCESS, null, null);
    }

    public static ScanCommandOutput FAILURE(IntLogger logger, ScanCommand scanCommand, String errorMessage, Exception exception) {
        return new ScanCommandOutput(logger, scanCommand, Result.FAILURE, errorMessage, exception);
    }

    private ScanCommandOutput(IntLogger logger, ScanCommand scanCommand, Result result, String errorMessage, Exception exception) {
        this.logger = logger;
        this.result = result;
        this.errorMessage = errorMessage;
        this.exception = exception;
        this.scanCommand = scanCommand;
    }

    private Optional<File> getResultFile(String resultDirectoryName) {
        File[] resultFiles;
        File resultDirectory = new File(this.scanCommand.getOutputDirectory(), resultDirectoryName);
        if (null != resultDirectory && resultDirectory.exists() && null != (resultFiles = resultDirectory.listFiles((dir, name) -> FilenameUtils.wildcardMatchOnSystem((String)name, (String)"*.json"))) && resultFiles.length == 1) {
            return Optional.of(resultFiles[0]);
        }
        this.logger.error(String.format("Exactly 1 result file was not found in the result directory: %s", resultDirectory.getAbsolutePath()));
        return Optional.empty();
    }

    public boolean wasDryRun() {
        return this.scanCommand.isDryRun();
    }

    public Optional<File> getScanSummaryFile() {
        return this.getResultFile(SCAN_RESULT_DIRECTORY);
    }

    public Optional<File> getDryRunFile() {
        return this.getResultFile(DRY_RUN_RESULT_DIRECTORY);
    }

    public File getSpecificRunOutputDirectory() {
        return this.scanCommand.getOutputDirectory();
    }

    public Result getResult() {
        return this.result;
    }

    public String getScanTarget() {
        return this.scanCommand.getTargetPath();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }
}

