/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPaths;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ScanCommand {
    private final File installDirectory;
    private final File outputDirectory;
    private final boolean dryRun;
    private final boolean shouldUseProxy;
    private final ProxyInfo proxyInfo;
    private final String scanCliOpts;
    private final int scanMemoryInMegabytes;
    private final String scheme;
    private final String host;
    private final String apiToken;
    private final String username;
    private final String password;
    private final int port;
    private final boolean runInsecure;
    private final String name;
    private final boolean snippetMatching;
    private final boolean snippetMatchingOnly;
    private final boolean fullSnippetScan;
    private final Set<String> excludePatterns;
    private final String additionalArguments;
    private final String targetPath;
    private final boolean verbose;
    private final boolean debug;
    private final String projectName;
    private final String versionName;

    public ScanCommand(File installDirectory, File outputDirectory, boolean dryRun, boolean shouldUseProxy, ProxyInfo proxyInfo, String scanCliOpts, int scanMemoryInMegabytes, String scheme, String host, String apiToken, String username, String password, int port, boolean runInsecure, String name, boolean snippetMatching, boolean snippetMatchingOnly, boolean fullSnippetScan, Set<String> excludePatterns, String additionalArguments, String targetPath, boolean verbose, boolean debug, String projectName, String versionName) {
        this.installDirectory = installDirectory;
        this.outputDirectory = outputDirectory;
        this.dryRun = dryRun;
        this.shouldUseProxy = shouldUseProxy;
        this.proxyInfo = proxyInfo;
        this.scanCliOpts = scanCliOpts;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.scheme = scheme;
        this.host = host;
        this.apiToken = apiToken;
        this.username = username;
        this.password = password;
        this.port = port;
        this.runInsecure = runInsecure;
        this.name = name;
        this.snippetMatching = snippetMatching;
        this.snippetMatchingOnly = snippetMatchingOnly;
        this.fullSnippetScan = fullSnippetScan;
        this.excludePatterns = excludePatterns;
        this.additionalArguments = additionalArguments;
        this.targetPath = targetPath;
        this.verbose = verbose;
        this.debug = debug;
        this.projectName = projectName;
        this.versionName = versionName;
    }

    public List<String> createCommandForProcessBuilder(IntLogger logger, ScanPaths scannerPaths, String specificRunOutputDirectoryPath) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        String additionalScanArguments;
        ArrayList<String> cmd = new ArrayList<String>();
        logger.debug("Using this java installation : " + scannerPaths.getPathToJavaExecutable());
        cmd.add(scannerPaths.getPathToJavaExecutable());
        cmd.add("-Done-jar.silent=true");
        cmd.add("-Done-jar.jar.path=" + scannerPaths.getPathToOneJar());
        if (this.shouldUseProxy) {
            String[] hubProxyInfo = this.proxyInfo;
            String proxyHost = hubProxyInfo.getHost();
            int proxyPort = hubProxyInfo.getPort();
            String proxyUsername = hubProxyInfo.getUsername();
            String proxyPassword = hubProxyInfo.getDecryptedPassword();
            String proxyNtlmDomain = hubProxyInfo.getNtlmDomain();
            String proxyNtlmWorkstation = hubProxyInfo.getNtlmWorkstation();
            cmd.add("-Dhttp.proxyHost=" + proxyHost);
            cmd.add("-Dhttp.proxyPort=" + Integer.toString(proxyPort));
            if (StringUtils.isNotBlank((CharSequence)proxyUsername) && StringUtils.isNotBlank((CharSequence)proxyPassword)) {
                cmd.add("-Dhttp.proxyUser=" + proxyUsername);
                cmd.add("-Dhttp.proxyPassword=" + proxyPassword);
            } else {
                cmd.add("-Dhttp.proxyUser=user");
                cmd.add("-Dhttp.proxyPassword=password");
            }
            if (StringUtils.isNotBlank((CharSequence)proxyNtlmDomain)) {
                cmd.add("-Dhttp.auth.ntlm.domain=" + proxyNtlmDomain);
            }
            if (StringUtils.isNotBlank((CharSequence)proxyNtlmWorkstation)) {
                cmd.add("-Dblackduck.http.auth.ntlm.workstation=" + proxyNtlmWorkstation);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.scanCliOpts)) {
            for (String scanOpt : this.scanCliOpts.split(" ")) {
                if (!StringUtils.isNotBlank((CharSequence)scanOpt)) continue;
                cmd.add(scanOpt);
            }
        }
        cmd.add("-Xmx" + this.scanMemoryInMegabytes + "m");
        cmd.add("-jar");
        cmd.add(scannerPaths.getPathToScanExecutable());
        cmd.add("--no-prompt");
        if (!this.dryRun) {
            int hubPort;
            cmd.add("--scheme");
            cmd.add(this.scheme);
            cmd.add("--host");
            cmd.add(this.host);
            logger.debug("Using this Hub hostname : '" + this.host + "'");
            if (StringUtils.isEmpty((CharSequence)this.apiToken)) {
                cmd.add("--username");
                cmd.add(this.username);
            }
            if ((hubPort = this.port) > 0) {
                cmd.add("--port");
                cmd.add(Integer.toString(hubPort));
            } else {
                logger.warn("Could not find a port to use for the Server.");
            }
            if (this.runInsecure) {
                cmd.add("--insecure");
            }
        }
        if (this.verbose) {
            cmd.add("-v");
        }
        if (this.debug) {
            cmd.add("--debug");
        }
        cmd.add("--logDir");
        cmd.add(specificRunOutputDirectoryPath);
        if (this.dryRun) {
            cmd.add("--dryRunWriteDir");
            cmd.add(specificRunOutputDirectoryPath);
        }
        cmd.add("--statusWriteDir");
        cmd.add(specificRunOutputDirectoryPath);
        if (StringUtils.isNotBlank((CharSequence)this.projectName) && StringUtils.isNotBlank((CharSequence)this.versionName)) {
            cmd.add("--project");
            cmd.add(this.projectName);
            cmd.add("--release");
            cmd.add(this.versionName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            cmd.add("--name");
            cmd.add(this.name);
        }
        if (this.snippetMatching) {
            cmd.add("--snippet-matching");
        }
        if (this.excludePatterns != null) {
            for (String exclusionPattern : this.excludePatterns) {
                if (!StringUtils.isNotBlank((CharSequence)exclusionPattern)) continue;
                cmd.add("--exclude");
                cmd.add(exclusionPattern);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(additionalScanArguments = this.additionalArguments))) {
            for (String additionalArgument : additionalScanArguments.split(" ")) {
                if (!StringUtils.isNotBlank((CharSequence)additionalArgument)) continue;
                cmd.add(additionalArgument);
            }
        }
        cmd.add(this.targetPath);
        return cmd;
    }

    public File getInstallDirectory() {
        return this.installDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isShouldUseProxy() {
        return this.shouldUseProxy;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunInsecure() {
        return this.runInsecure;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnippetMatching() {
        return this.snippetMatching;
    }

    public boolean isSnippetMatchingOnly() {
        return this.snippetMatchingOnly;
    }

    public boolean isFullSnippetScan() {
        return this.fullSnippetScan;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVersionName() {
        return this.versionName;
    }
}

