/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.service.model.HubFilter;
import com.synopsys.integration.blackduck.service.model.HubQuery;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.body.FileBodyContent;
import com.synopsys.integration.rest.body.MapBodyContent;
import com.synopsys.integration.rest.body.StringBodyContent;
import com.synopsys.integration.rest.request.Request;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RequestFactory {
    public static final String LIMIT_PARAMETER = "limit";
    public static final String OFFSET_PARAMETER = "offset";
    public static final String Q_PARAMETER = "q";
    public static final String FILTER_PARAMETER = "filter";
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_OFFSET = 0;

    public static Request.Builder createCommonGetRequestBuilder() {
        return RequestFactory.createCommonGetRequestBuilder(null, Optional.empty(), 100, 0);
    }

    public static Request.Builder createCommonGetRequestBuilder(String uri) {
        return RequestFactory.createCommonGetRequestBuilder(uri, Optional.empty(), 100, 0);
    }

    public static Request.Builder createCommonGetRequestBuilder(Optional<HubQuery> hubQuery) {
        return RequestFactory.createCommonGetRequestBuilder(null, hubQuery, 100, 0);
    }

    public static Request.Builder createCommonGetRequestBuilder(int limit, int offset) {
        return RequestFactory.createCommonGetRequestBuilder(null, Optional.empty(), limit, offset);
    }

    public static Request.Builder createCommonGetRequestBuilder(String uri, Optional<HubQuery> hubQuery) {
        return RequestFactory.createCommonGetRequestBuilder(uri, hubQuery, 100, 0);
    }

    public static Request.Builder createCommonGetRequestBuilder(String uri, int limit, int offset) {
        return RequestFactory.createCommonGetRequestBuilder(uri, Optional.empty(), limit, offset);
    }

    public static Request.Builder createCommonGetRequestBuilder(Optional<HubQuery> hubQuery, int limit, int offset) {
        return RequestFactory.createCommonGetRequestBuilder(null, hubQuery, limit, offset);
    }

    public static Request.Builder createCommonGetRequestBuilder(String uri, Optional<HubQuery> hubQuery, int limit, int offset) {
        return RequestFactory.createCommonGetRequestBuilder(uri, hubQuery, null, limit, offset);
    }

    public static Request.Builder createCommonGetRequestBuilder(String uri, Optional<HubQuery> hubQuery, HubFilter hubFilter, int limit, int offset) {
        Request.Builder requestBuilder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            requestBuilder.uri(uri);
        }
        RequestFactory.addHubQuery(requestBuilder, hubQuery);
        RequestFactory.addHubFilter(requestBuilder, hubFilter);
        RequestFactory.addLimit(requestBuilder, limit);
        RequestFactory.addOffset(requestBuilder, offset);
        return requestBuilder;
    }

    public static Request createCommonGetRequest(String uri) {
        return RequestFactory.createCommonGetRequestBuilder(uri).build();
    }

    public static Request.Builder addLimit(Request.Builder requestBuilder, int limit) {
        requestBuilder.addQueryParameter(LIMIT_PARAMETER, String.valueOf(limit));
        return requestBuilder;
    }

    public static Request.Builder addOffset(Request.Builder requestBuilder, int offset) {
        requestBuilder.addQueryParameter(OFFSET_PARAMETER, String.valueOf(offset));
        return requestBuilder;
    }

    public static Request.Builder addHubQuery(Request.Builder requestBuilder, Optional<HubQuery> hubQuery) {
        if (hubQuery.isPresent()) {
            requestBuilder.addQueryParameter(Q_PARAMETER, hubQuery.get().getParameter());
        }
        return requestBuilder;
    }

    public static Request.Builder addHubFilter(Request.Builder requestBuilder, HubFilter hubFilter) {
        if (hubFilter != null) {
            hubFilter.getFilterParameters().forEach(parameter -> requestBuilder.addQueryParameter(FILTER_PARAMETER, (String)parameter));
        }
        return requestBuilder;
    }

    public static Request.Builder createCommonPostRequestBuilder(File bodyContentFile) {
        return new Request.Builder().method(HttpMethod.POST).bodyContent(new FileBodyContent(bodyContentFile));
    }

    public static Request.Builder createCommonPostRequestBuilder(Map<String, String> bodyContentMap) {
        return new Request.Builder().method(HttpMethod.POST).bodyContent(new MapBodyContent(bodyContentMap));
    }

    public static Request.Builder createCommonPostRequestBuilder(String bodyContent) {
        return new Request.Builder().method(HttpMethod.POST).bodyContent(new StringBodyContent(bodyContent));
    }

    public static Request.Builder createCommonPutRequestBuilder(String bodyContent) {
        return new Request.Builder().method(HttpMethod.PUT).bodyContent(new StringBodyContent(bodyContent));
    }
}

