/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionPhaseType;
import com.synopsys.integration.blackduck.service.model.ProjectRequestBuilder;
import com.synopsys.integration.blackduck.service.model.ProjectRequestField;
import com.synopsys.integration.blackduck.service.model.ProjectVersionRequestField;
import com.synopsys.integration.validator.AbstractValidator;
import com.synopsys.integration.validator.ValidationResult;
import com.synopsys.integration.validator.ValidationResultEnum;
import com.synopsys.integration.validator.ValidationResults;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class ProjectRequestValidator
extends AbstractValidator {
    private final String projectName;
    private final String distribution;
    private final String phase;
    private final String versionName;
    private final String releasedOn;

    public ProjectRequestValidator(ProjectRequestBuilder projectRequestBuilder) {
        this.projectName = projectRequestBuilder.getProjectName();
        this.distribution = projectRequestBuilder.getDistribution();
        this.phase = projectRequestBuilder.getPhase();
        this.versionName = projectRequestBuilder.getVersionName();
        this.releasedOn = projectRequestBuilder.getReleasedOn();
    }

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateProject(result);
        this.validateVersion(result);
        return result;
    }

    public void validateProject(ValidationResults result) {
        if (StringUtils.isBlank((CharSequence)this.projectName)) {
            result.addResult(ProjectRequestField.NAME, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a project name."));
        }
    }

    public void validateVersion(ValidationResults result) {
        if (StringUtils.isBlank((CharSequence)this.versionName)) {
            result.addResult(ProjectVersionRequestField.VERSIONNAME, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version name."));
        }
        if (StringUtils.isBlank((CharSequence)this.distribution)) {
            result.addResult(ProjectVersionRequestField.DISTRIBUTION, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version distribution."));
        } else {
            try {
                ProjectVersionDistributionType.valueOf(this.distribution.toUpperCase());
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.DISTRIBUTION, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.phase)) {
            result.addResult(ProjectVersionRequestField.PHASE, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version phase."));
        } else {
            try {
                ProjectVersionPhaseType.valueOf(this.phase.toUpperCase());
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.PHASE, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.releasedOn)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                sdf.parse(this.releasedOn);
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.RELEASEDON, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
    }
}

