/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.enumeration.PolicySeverityType;
import com.synopsys.integration.blackduck.api.generated.component.ComponentVersionPolicyViolationDetails;
import com.synopsys.integration.blackduck.api.generated.component.NameValuePairView;
import com.synopsys.integration.blackduck.api.generated.enumeration.PolicySummaryStatusType;
import com.synopsys.integration.blackduck.api.generated.view.VersionBomPolicyStatusView;
import com.synopsys.integration.blackduck.service.model.ComponentVersionPolicyViolationCount;
import com.synopsys.integration.blackduck.service.model.ComponentVersionStatusCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PolicyStatusDescription {
    private final VersionBomPolicyStatusView policyStatusItem;
    private final Map<PolicySummaryStatusType, ComponentVersionStatusCount> policyStatusCount = new HashMap<PolicySummaryStatusType, ComponentVersionStatusCount>();
    private final Map<PolicySeverityType, ComponentVersionPolicyViolationCount> policySeverityCount = new HashMap<PolicySeverityType, ComponentVersionPolicyViolationCount>();

    public PolicyStatusDescription(VersionBomPolicyStatusView policyStatusItem) {
        this.policyStatusItem = policyStatusItem;
        this.populatePolicySeverityMap();
        this.populatePolicyStatusMap();
    }

    private void populatePolicySeverityMap() {
        List<NameValuePairView> nameValuePairs;
        ComponentVersionPolicyViolationDetails policyViolationDetails = this.policyStatusItem.componentVersionPolicyViolationDetails;
        if (policyViolationDetails != null && PolicySummaryStatusType.IN_VIOLATION.equals((Object)this.policyStatusItem.overallStatus) && (nameValuePairs = policyViolationDetails.severityLevels) != null) {
            for (NameValuePairView nameValuePairView : nameValuePairs) {
                if (nameValuePairView.name == null) continue;
                ComponentVersionPolicyViolationCount componentVersionPolicyViolationCount = new ComponentVersionPolicyViolationCount(nameValuePairView);
                this.policySeverityCount.put(componentVersionPolicyViolationCount.name, componentVersionPolicyViolationCount);
            }
        }
    }

    private void populatePolicyStatusMap() {
        List<NameValuePairView> nameValuePairs = this.policyStatusItem.componentVersionStatusCounts;
        if (nameValuePairs != null) {
            for (NameValuePairView nameValuePairView : nameValuePairs) {
                if (nameValuePairView.name == null) continue;
                ComponentVersionStatusCount componentVersionStatusCount = new ComponentVersionStatusCount(nameValuePairView);
                this.policyStatusCount.put(componentVersionStatusCount.name, componentVersionStatusCount);
            }
        }
    }

    public String getPolicyStatusMessage() {
        if (this.policyStatusItem.componentVersionStatusCounts == null || this.policyStatusItem.componentVersionStatusCounts.size() == 0) {
            return "The Hub found no components.";
        }
        int inViolationCount = this.getCountOfStatus(PolicySummaryStatusType.IN_VIOLATION);
        int inViolationOverriddenCount = this.getCountOfStatus(PolicySummaryStatusType.IN_VIOLATION_OVERRIDDEN);
        int notInViolationCount = this.getCountOfStatus(PolicySummaryStatusType.NOT_IN_VIOLATION);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The Hub found: ");
        stringBuilder.append(inViolationCount);
        stringBuilder.append(" components in violation");
        if (this.getCountOfStatus(PolicySummaryStatusType.IN_VIOLATION) != 0) {
            stringBuilder.append(" (");
            this.getPolicySeverityMessage(stringBuilder);
            stringBuilder.append(")");
        }
        stringBuilder.append(", ");
        stringBuilder.append(inViolationOverriddenCount);
        stringBuilder.append(" components in violation, but overridden, and ");
        stringBuilder.append(notInViolationCount);
        stringBuilder.append(" components not in violation.");
        return stringBuilder.toString();
    }

    private void getPolicySeverityMessage(StringBuilder stringBuilder) {
        ArrayList<String> policySeverityItems = new ArrayList<String>();
        stringBuilder.append("Policy Severity counts: ");
        for (PolicySeverityType policySeverityEnum : this.policySeverityCount.keySet()) {
            ComponentVersionPolicyViolationCount policySeverity = this.policySeverityCount.get((Object)policySeverityEnum);
            if (policySeverity == null) continue;
            policySeverityItems.add(policySeverity.value + " component(s) have a severity level of " + policySeverityEnum.toString());
        }
        stringBuilder.append(StringUtils.join(policySeverityItems, (String)", "));
    }

    public ComponentVersionStatusCount getCountInViolation() {
        return this.policyStatusCount.get((Object)PolicySummaryStatusType.IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountNotInViolation() {
        return this.policyStatusCount.get((Object)PolicySummaryStatusType.NOT_IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountInViolationOverridden() {
        return this.policyStatusCount.get((Object)PolicySummaryStatusType.IN_VIOLATION_OVERRIDDEN);
    }

    public int getCountOfStatus(PolicySummaryStatusType overallStatus) {
        ComponentVersionStatusCount count = this.policyStatusCount.get((Object)overallStatus);
        if (count == null) {
            return 0;
        }
        return count.value;
    }

    public int getCountOfSeverity(PolicySeverityType severity) {
        ComponentVersionPolicyViolationCount count = this.policySeverityCount.get((Object)severity);
        if (count == null) {
            return 0;
        }
        return count.value;
    }
}

