/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleCategoryType;
import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleConditionType;
import com.synopsys.integration.blackduck.api.generated.component.PolicyRuleExpressionView;
import com.synopsys.integration.blackduck.api.generated.view.PolicyRuleViewV2;
import java.util.Collections;
import java.util.List;

public class PolicyRuleModel {
    private final PolicyRuleViewV2 rule;

    public PolicyRuleModel(PolicyRuleViewV2 rule) {
        this.rule = rule;
    }

    public boolean hasExpressions() {
        return this.rule != null && this.rule.expression != null && this.rule.expression.expressions != null && !this.rule.expression.expressions.isEmpty();
    }

    public List<PolicyRuleExpressionView> getExpressionList() {
        if (this.hasExpressions()) {
            return this.rule.expression.expressions;
        }
        return Collections.emptyList();
    }

    public boolean hasOnlyProjectLevelConditions() {
        boolean hasNonProjectLevelCondition = false;
        for (PolicyRuleExpressionView expression : this.getExpressionList()) {
            PolicyRuleConditionType condition = PolicyRuleConditionType.valueOf(expression.name);
            if (condition == PolicyRuleConditionType.UNKNOWN_RULE_CONDTION || condition.policyRuleCategory != PolicyRuleCategoryType.COMPONENT) continue;
            hasNonProjectLevelCondition = true;
        }
        return !hasNonProjectLevelCondition;
    }
}

