/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.exception.DoesNotExistException;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.HubQuery;
import com.synopsys.integration.blackduck.service.model.ProjectVersionWrapper;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import java.util.List;
import java.util.Optional;

public class ProjectGetService
extends DataService {
    public ProjectGetService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public List<ProjectView> getAllProjectMatches(String projectName) throws IntegrationException {
        Optional<HubQuery> hubQuery = HubQuery.createQuery("name", projectName);
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(hubQuery);
        List<ProjectView> allProjectItems = this.hubService.getAllResponses(ApiDiscovery.PROJECTS_LINK_RESPONSE, requestBuilder);
        return allProjectItems;
    }

    public List<ProjectView> getProjectMatches(String projectName, int limit) throws IntegrationException {
        Optional<HubQuery> hubQuery = HubQuery.createQuery("name", projectName);
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(hubQuery, limit, 0);
        List<ProjectView> projectItems = this.hubService.getResponses(ApiDiscovery.PROJECTS_LINK_RESPONSE, requestBuilder, false);
        return projectItems;
    }

    @Deprecated
    public ProjectView getProjectByName(String projectName) throws IntegrationException {
        Optional<ProjectView> projectView = this.getProjectViewByProjectName(projectName);
        if (projectView.isPresent()) {
            return projectView.get();
        }
        throw new DoesNotExistException("This Project does not exist. Project: " + projectName);
    }

    public Optional<ProjectView> getProjectViewByProjectName(String projectName) throws IntegrationException {
        List<ProjectView> allProjectItems = this.getAllProjectMatches(projectName);
        for (ProjectView project : allProjectItems) {
            if (!projectName.equalsIgnoreCase(project.name)) continue;
            return Optional.of(project);
        }
        return Optional.empty();
    }

    @Deprecated
    public ProjectVersionView getProjectVersion(ProjectView project, String projectVersionName) throws IntegrationException {
        Optional<ProjectVersionView> projectVersionView = this.getProjectVersionViewByProjectVersionName(project, projectVersionName);
        if (projectVersionView.isPresent()) {
            return projectVersionView.get();
        }
        throw new DoesNotExistException(String.format("Could not find the version: %s for project: %s", projectVersionName, project.name));
    }

    @Deprecated
    public ProjectVersionWrapper getProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectView = this.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.getProjectVersion(projectView, projectVersionName);
        return new ProjectVersionWrapper(projectView, projectVersionView);
    }

    public Optional<ProjectVersionView> getProjectVersionViewByProjectVersionName(ProjectView projectView, String projectVersionName) throws IntegrationException {
        Optional<HubQuery> hubQuery = HubQuery.createQuery("versionName", projectVersionName);
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder(hubQuery);
        List<ProjectVersionView> allProjectVersionMatchingItems = this.hubService.getAllResponses(projectView, ProjectView.VERSIONS_LINK_RESPONSE, requestBuilder);
        Optional<ProjectVersionView> projectVersion = this.findMatchingProjectVersionView(allProjectVersionMatchingItems, projectVersionName);
        return projectVersion;
    }

    @Deprecated
    public ProjectVersionView findMatchingVersion(List<ProjectVersionView> projectVersions, String projectVersionName) throws HubIntegrationException {
        for (ProjectVersionView version : projectVersions) {
            if (!projectVersionName.equals(version.versionName)) continue;
            return version;
        }
        return null;
    }

    public Optional<ProjectVersionView> findMatchingProjectVersionView(List<ProjectVersionView> projectVersions, String projectVersionName) {
        for (ProjectVersionView version : projectVersions) {
            if (!projectVersionName.equals(version.versionName)) continue;
            return Optional.of(version);
        }
        return Optional.empty();
    }
}

