/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.synopsys.integration.blackduck.api.generated.component.VersionBomLicenseView;
import com.synopsys.integration.blackduck.api.generated.view.ComplexLicenseView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentSearchResultView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentVersionView;
import com.synopsys.integration.blackduck.api.generated.view.LicenseView;
import com.synopsys.integration.blackduck.service.ComponentService;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;

public class LicenseService
extends DataService {
    private final ComponentService componentDataService;

    public LicenseService(HubService hubService, IntLogger logger, ComponentService componentDataService) {
        super(hubService, logger);
        this.componentDataService = componentDataService;
    }

    public ComplexLicenseView getComplexLicenseItemFromComponent(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.componentDataService.getExactComponentMatch(externalId);
        String componentVersionUrl = componentSearchView.version;
        ComponentVersionView componentVersion = this.hubService.getResponse(componentVersionUrl, ComponentVersionView.class);
        return componentVersion.license;
    }

    public LicenseView getLicenseView(VersionBomLicenseView versionBomLicenseView) throws IntegrationException {
        return this.getLicenseView(versionBomLicenseView.license);
    }

    public LicenseView getLicenseView(ComplexLicenseView complexLicenseView) throws IntegrationException {
        return this.getLicenseView(complexLicenseView.license);
    }

    public LicenseView getLicenseView(String licenseUrl) throws IntegrationException {
        if (licenseUrl == null) {
            return null;
        }
        LicenseView licenseView = this.hubService.getResponse(licenseUrl, LicenseView.class);
        return licenseView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLicenseText(LicenseView licenseView) throws IntegrationException {
        String licenseTextUrl = this.hubService.getFirstLinkSafely(licenseView, "text");
        try (Response response = this.hubService.executeGetRequest(licenseTextUrl);){
            String string = response.getContentString();
            return string;
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }
}

