/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.blackduck.service.HubResponseTransformer;
import com.synopsys.integration.blackduck.service.model.PagedRequest;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HubResponsesTransformer {
    private final BlackduckRestConnection restConnection;
    private final HubResponseTransformer hubResponseTransformer;
    private final JsonParser jsonParser;

    public HubResponsesTransformer(BlackduckRestConnection restConnection, HubResponseTransformer hubResponseTransformer, JsonParser jsonParser) {
        this.restConnection = restConnection;
        this.hubResponseTransformer = hubResponseTransformer;
        this.jsonParser = jsonParser;
    }

    public <T extends HubResponse> List<T> getResponses(PagedRequest pagedRequest, Class<T> clazz) throws IntegrationException {
        return this.getResponses(pagedRequest, clazz, true, null);
    }

    public <T extends HubResponse> List<T> getResponses(PagedRequest pagedRequest, Class<T> clazz, boolean getAll) throws IntegrationException {
        return this.getResponses(pagedRequest, clazz, getAll, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends HubResponse> List<T> getResponses(PagedRequest pagedRequest, Class<T> clazz, boolean getAll, Map<String, Class<? extends T>> typeMap) throws IntegrationException {
        LinkedList<Object> allResponses = new LinkedList<Object>();
        int totalCount = 0;
        int currentOffset = pagedRequest.getOffset();
        try (Response initialResponse = this.restConnection.executeRequest(pagedRequest.createRequest());){
            String initialJsonResponse = initialResponse.getContentString();
            JsonObject initialJsonObject = this.jsonParser.parse(initialJsonResponse).getAsJsonObject();
            if (typeMap != null) {
                allResponses.addAll(this.getResponses(initialJsonObject, clazz, typeMap));
            } else {
                allResponses.addAll(this.getResponses(initialJsonObject, clazz));
            }
            if (!getAll) {
                LinkedList<Object> linkedList = allResponses;
                return linkedList;
            }
            totalCount = initialJsonObject.get("totalCount").getAsInt();
            while (allResponses.size() < totalCount) {
                if (currentOffset >= totalCount) return allResponses;
                PagedRequest offsetPagedRequest = new PagedRequest(pagedRequest.getRequestBuilder(), currentOffset += pagedRequest.getLimit(), pagedRequest.getLimit());
                try {
                    Response response = this.restConnection.executeRequest(offsetPagedRequest.createRequest());
                    Throwable throwable = null;
                    try {
                        String jsonResponse = response.getContentString();
                        JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
                        if (typeMap != null) {
                            allResponses.addAll(this.getResponses(jsonObject, clazz, typeMap));
                            continue;
                        }
                        allResponses.addAll(this.getResponses(jsonObject, clazz));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        response.close();
                    }
                }
                catch (IOException e) {
                    throw new HubIntegrationException(e);
                }
            }
            return allResponses;
        }
        catch (IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public <T extends HubResponse> List<T> getResponses(JsonArray responsesArray, Class<T> clazz) {
        LinkedList<T> itemList = new LinkedList<T>();
        for (JsonElement element : responsesArray) {
            T item = this.hubResponseTransformer.getResponseAs(element, clazz);
            itemList.add(item);
        }
        return itemList;
    }

    public <T extends HubResponse> List<T> getResponses(JsonObject jsonObject, Class<T> clazz) throws IntegrationException {
        LinkedList<T> responseList = new LinkedList<T>();
        JsonElement responsesElement = jsonObject.get("items");
        JsonArray responsesArray = responsesElement.getAsJsonArray();
        for (JsonElement element : responsesArray) {
            T item = this.hubResponseTransformer.getResponseAs(element, clazz);
            responseList.add(item);
        }
        return responseList;
    }

    public <T extends HubResponse> List<T> getResponses(JsonObject jsonObject, Class<T> clazz, Map<String, Class<? extends T>> typeMap) throws IntegrationException {
        LinkedList<T> responseList = new LinkedList<T>();
        JsonElement responsesElement = jsonObject.get("items");
        JsonArray responsesArray = responsesElement.getAsJsonArray();
        for (JsonElement element : responsesArray) {
            String type;
            Class<Object> actualClass = clazz;
            JsonObject elementObject = element.getAsJsonObject();
            if (elementObject.has("type") && typeMap.containsKey(type = elementObject.get("type").getAsString())) {
                actualClass = typeMap.get(type);
            }
            T item = this.hubResponseTransformer.getResponseAs(element, actualClass);
            responseList.add(item);
        }
        return responseList;
    }
}

