/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.configuration;

import com.synopsys.integration.blackduck.rest.ApiTokenRestConnection;
import com.synopsys.integration.blackduck.rest.ApiTokenRestConnectionBuilder;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.blackduck.rest.CredentialsRestConnection;
import com.synopsys.integration.blackduck.rest.CredentialsRestConnectionBuilder;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.util.Stringable;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class HubServerConfig
extends Stringable
implements Serializable {
    private static final long serialVersionUID = -1581638027683631935L;
    private final URL hubUrl;
    private final int timeoutSeconds;
    private final Credentials credentials;
    private final String apiToken;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;

    public HubServerConfig(URL url, int timeoutSeconds, Credentials credentials, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.hubUrl = url;
        this.timeoutSeconds = timeoutSeconds;
        this.credentials = credentials;
        this.apiToken = null;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public HubServerConfig(URL url, int timeoutSeconds, String apiToken, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.hubUrl = url;
        this.timeoutSeconds = timeoutSeconds;
        this.credentials = null;
        this.apiToken = apiToken;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public boolean shouldUseProxyForHub() {
        return this.proxyInfo != null && this.proxyInfo.shouldUseProxyForUrl(this.hubUrl);
    }

    public void print(IntLogger logger) {
        if (this.getHubUrl() != null) {
            logger.alwaysLog("--> Hub Server Url: " + this.getHubUrl());
        }
        if (this.getGlobalCredentials() != null && StringUtils.isNotBlank((CharSequence)this.getGlobalCredentials().getUsername())) {
            logger.alwaysLog("--> Hub User: " + this.getGlobalCredentials().getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiToken)) {
            logger.alwaysLog("--> Hub API Token Used");
        }
        if (this.alwaysTrustServerCertificate) {
            logger.alwaysLog("--> Trust Hub certificate: " + this.isAlwaysTrustServerCertificate());
        }
        if (this.proxyInfo != null) {
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getHost())) {
                logger.alwaysLog("--> Proxy Host: " + this.proxyInfo.getHost());
            }
            if (this.proxyInfo.getPort() > 0) {
                logger.alwaysLog("--> Proxy Port: " + this.proxyInfo.getPort());
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getIgnoredProxyHosts())) {
                logger.alwaysLog("--> No Proxy Hosts: " + this.proxyInfo.getIgnoredProxyHosts());
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getUsername())) {
                logger.alwaysLog("--> Proxy Username: " + this.proxyInfo.getUsername());
            }
        }
    }

    public BlackduckRestConnection createRestConnection(IntLogger logger) throws EncryptionException {
        if (this.usingApiToken()) {
            return this.createApiTokenRestConnection(logger);
        }
        return this.createCredentialsRestConnection(logger);
    }

    public CredentialsRestConnection createCredentialsRestConnection(IntLogger logger) throws EncryptionException {
        CredentialsRestConnectionBuilder builder = new CredentialsRestConnectionBuilder();
        builder.setLogger(logger);
        builder.setBaseUrl(this.getHubUrl().toString());
        builder.setTimeout(this.getTimeout());
        builder.applyCredentials(this.getGlobalCredentials());
        builder.setAlwaysTrustServerCertificate(this.isAlwaysTrustServerCertificate());
        builder.applyProxyInfo(this.getProxyInfo());
        return (CredentialsRestConnection)builder.build();
    }

    public ApiTokenRestConnection createApiTokenRestConnection(IntLogger logger) {
        ApiTokenRestConnectionBuilder builder = new ApiTokenRestConnectionBuilder();
        builder.setLogger(logger);
        builder.setBaseUrl(this.getHubUrl().toString());
        builder.setTimeout(this.getTimeout());
        builder.setApiToken(this.getApiToken());
        builder.setAlwaysTrustServerCertificate(this.isAlwaysTrustServerCertificate());
        builder.applyProxyInfo(this.getProxyInfo());
        return (ApiTokenRestConnection)builder.build();
    }

    public boolean usingApiToken() {
        return StringUtils.isNotBlank((CharSequence)this.apiToken);
    }

    public URL getHubUrl() {
        return this.hubUrl;
    }

    public Credentials getGlobalCredentials() {
        return this.credentials;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }
}

