/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.api.view;

import com.synopsys.integration.blackduck.api.core.HubView;
import com.synopsys.integration.blackduck.api.core.ResourceLink;
import com.synopsys.integration.blackduck.api.core.ResourceMetadata;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class MetaHandler {
    private final IntLogger logger;

    public MetaHandler(IntLogger logger) {
        this.logger = logger;
    }

    public boolean hasLink(HubView view, String linkKey) throws HubIntegrationException {
        ResourceMetadata meta = view._meta;
        if (meta == null) {
            return false;
        }
        List<ResourceLink> links = meta.links;
        if (links == null) {
            return false;
        }
        for (ResourceLink link : links) {
            if (!link.rel.equals(linkKey)) continue;
            return true;
        }
        return false;
    }

    public String getFirstLink(HubView view, String linkKey) throws HubIntegrationException {
        List<ResourceLink> links = this.getLinkViews(view);
        StringBuilder linksAvailable = new StringBuilder();
        linksAvailable.append("Could not find the link '" + linkKey + "', these are the available links : ");
        int i = 0;
        for (ResourceLink link : links) {
            if (link.rel.equals(linkKey)) {
                return link.href;
            }
            if (i > 0) {
                linksAvailable.append(", ");
            }
            linksAvailable.append("'" + link.rel + "'");
            ++i;
        }
        linksAvailable.append(". For View : " + view._meta.href);
        throw new HubIntegrationException(linksAvailable.toString());
    }

    public String getFirstLinkSafely(HubView view, String linkKey) {
        try {
            String link = this.getFirstLink(view, linkKey);
            return link;
        }
        catch (HubIntegrationException e) {
            this.logger.debug("Link '" + linkKey + "' not found on view : " + view.json, e);
            return null;
        }
    }

    public List<String> getLinks(HubView view, String linkKey) throws HubIntegrationException {
        List<ResourceLink> links = this.getLinkViews(view);
        ArrayList<String> linkHrefs = new ArrayList<String>();
        StringBuilder linksAvailable = new StringBuilder();
        linksAvailable.append("Could not find the link '" + linkKey + "', these are the available links : ");
        int i = 0;
        for (ResourceLink link : links) {
            if (link.rel.equals(linkKey)) {
                linkHrefs.add(link.href);
            }
            if (i > 0) {
                linksAvailable.append(", ");
            }
            linksAvailable.append("'" + link.rel + "'");
            ++i;
        }
        if (!linkHrefs.isEmpty()) {
            return linkHrefs;
        }
        linksAvailable.append(". For View : " + view._meta.href);
        throw new HubIntegrationException(linksAvailable.toString());
    }

    public ResourceMetadata getMetaView(HubView view) throws HubIntegrationException {
        ResourceMetadata meta = view._meta;
        if (meta == null) {
            throw new HubIntegrationException("Could not find meta information for this view : " + view.json);
        }
        return meta;
    }

    public List<ResourceLink> getLinkViews(HubView view) throws HubIntegrationException {
        ResourceMetadata meta = this.getMetaView(view);
        List<ResourceLink> links = meta.links;
        if (links == null) {
            throw new HubIntegrationException("Could not find any links for this view : " + view.json);
        }
        return links;
    }

    public List<String> getAllowedMethods(HubView view) throws HubIntegrationException {
        ResourceMetadata meta = this.getMetaView(view);
        return meta.allow;
    }

    public String getHref(HubView view) throws HubIntegrationException {
        ResourceMetadata meta = this.getMetaView(view);
        String href = meta.href;
        if (href == null) {
            if (this.logger != null) {
                this.logger.error("Hub View has no href : " + view.json);
            }
            throw new HubIntegrationException("This Hub view does not have any href information.");
        }
        return href;
    }
}

