/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.blackduck;

import com.synopsys.integration.blackduck.api.core.HubPath;
import com.synopsys.integration.blackduck.api.core.HubPathMultipleResponses;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.HubService;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.request.Request;
import com.xebialabs.xlrelease.plugin.blackduck.view.ReleaseWrapperView;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class HubCompositeService
extends DataService {
    public HubCompositeService(HubService hubService, IntLogger logger) {
        super(hubService, logger);
    }

    public List<ReleaseWrapperView> getAllReleases(String projectId) throws IntegrationException {
        Request.Builder requestBuilder = RequestFactory.createCommonGetRequestBuilder();
        requestBuilder.addQueryParameter("additionalInfoOptions", "RiskProfile");
        HubPathMultipleResponses<ReleaseWrapperView> hubPathMultipleResponses = new HubPathMultipleResponses<ReleaseWrapperView>(this.createCompositeProjectReleaseHubPath(projectId), ReleaseWrapperView.class);
        return this.hubService.getAllResponses(hubPathMultipleResponses, requestBuilder);
    }

    public String getProjectIdByView(ProjectView projectView) throws MalformedURLException, HubIntegrationException {
        URL url = new URL(this.hubService.getHref(projectView));
        return url.getPath().replace(ApiDiscovery.PROJECTS_LINK.toString() + "/", "");
    }

    public String getProjectVersionIdByView(ProjectVersionView projectVersionView) throws MalformedURLException, HubIntegrationException {
        URL url = new URL(this.hubService.getHref(projectVersionView));
        URL projectUrl = new URL(this.hubService.getFirstLink(projectVersionView, "project"));
        return url.getPath().replace(projectUrl.getPath() + "/versions/", "");
    }

    private HubPath createCompositeProjectReleaseHubPath(String projectId) {
        return new HubPath("/api/v1/composite/projects/" + projectId + "/releases");
    }
}

