/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.validator;

import com.synopsys.integration.validator.FieldEnum;
import com.synopsys.integration.validator.ValidationResult;
import com.synopsys.integration.validator.ValidationResultEnum;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ValidationResults {
    private final Map<FieldEnum, Set<ValidationResult>> resultMap = new LinkedHashMap<FieldEnum, Set<ValidationResult>>();
    private final Set<ValidationResultEnum> status = EnumSet.noneOf(ValidationResultEnum.class);

    public void addAllResults(Map<FieldEnum, Set<ValidationResult>> results) {
        for (Map.Entry<FieldEnum, Set<ValidationResult>> entry : results.entrySet()) {
            for (ValidationResult result : entry.getValue()) {
                this.addResult(entry.getKey(), result);
            }
        }
    }

    public void addResult(FieldEnum field, ValidationResult result) {
        if (this.resultMap.containsKey(field)) {
            Set<ValidationResult> results = this.resultMap.get(field);
            results.add(result);
            this.status.add(result.getResultType());
        } else {
            LinkedHashSet<ValidationResult> newResults = new LinkedHashSet<ValidationResult>();
            newResults.add(result);
            this.resultMap.put(field, newResults);
            this.status.add(result.getResultType());
        }
    }

    public String getResultString(FieldEnum field) {
        Set<ValidationResult> results = this.resultMap.get(field);
        return StringUtils.join(results, (String)System.lineSeparator());
    }

    public String getAllResultString() {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (Map.Entry<FieldEnum, Set<ValidationResult>> result : this.resultMap.entrySet()) {
            String fieldResults = StringUtils.join((Iterable)result.getValue(), (String)" , ");
            results.add(result.getKey() + " = " + fieldResults);
        }
        String resultString = "";
        if (!results.isEmpty()) {
            resultString = StringUtils.join(results, (String)System.lineSeparator());
        }
        return resultString;
    }

    public Map<FieldEnum, Set<ValidationResult>> getResultMap() {
        return this.resultMap;
    }

    public Set<ValidationResultEnum> getValidationStatus() {
        return this.status;
    }

    public boolean hasErrors() {
        return this.status.contains((Object)ValidationResultEnum.ERROR);
    }

    public boolean hasWarnings() {
        return this.status.contains((Object)ValidationResultEnum.WARN);
    }

    public boolean isSuccess() {
        return this.status.isEmpty();
    }

    public boolean isEmpty() {
        return this.resultMap.isEmpty();
    }
}

