/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.rest;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApiTokenRestConnection
extends BlackduckRestConnection {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final String hubApiToken;

    public ApiTokenRestConnection(IntLogger logger, URL hubBaseUrl, String hubApiToken, int timeout, ProxyInfo proxyInfo) {
        super(logger, hubBaseUrl, timeout, proxyInfo);
        this.hubApiToken = hubApiToken;
    }

    @Override
    public void populateHttpClientBuilder(HttpClientBuilder httpClientBuilder, RequestConfig.Builder defaultRequestConfigBuilder) throws IntegrationException {
        if (StringUtils.isNotBlank((CharSequence)this.hubApiToken)) {
            httpClientBuilder.setDefaultCookieStore(new BasicCookieStore());
            defaultRequestConfigBuilder.setCookieSpec("default");
        }
    }

    @Override
    public void authenticateWithBlackduck() throws IntegrationException {
        URL authenticationUrl;
        try {
            authenticationUrl = new URL(this.getBaseUrl(), "api/tokens/authenticate");
        }
        catch (MalformedURLException e) {
            throw new IntegrationException("Error constructing the authentication URL: " + e.getMessage(), e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.hubApiToken)) {
            RequestBuilder requestBuilder = this.createRequestBuilder(HttpMethod.POST, this.getRequestHeaders());
            requestBuilder.setCharset(Charsets.UTF_8);
            requestBuilder.setUri(authenticationUrl.toString());
            HttpUriRequest request = requestBuilder.build();
            this.logRequestHeaders(request);
            try (CloseableHttpResponse response = this.getClient().execute(request);){
                this.logResponseHeaders(response);
                int statusCode = response.getStatusLine().getStatusCode();
                String statusMessage = response.getStatusLine().getReasonPhrase();
                if (statusCode < 200 || statusCode >= 300) {
                    throw new IntegrationRestException(statusCode, statusMessage, String.format("Connection Error: %s %s", statusCode, statusMessage));
                }
                this.addCommonRequestHeader(AUTHORIZATION_HEADER, "Bearer " + this.readBearerToken(response));
                Header csrfToken = response.getFirstHeader("X-CSRF-TOKEN");
                if (csrfToken != null) {
                    this.addCommonRequestHeader("X-CSRF-TOKEN", csrfToken.getValue());
                } else {
                    this.logger.error("No CSRF token found when authenticating");
                }
            }
            catch (IOException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "token " + this.hubApiToken);
        return headers;
    }

    private String readBearerToken(CloseableHttpResponse response) throws IOException {
        JsonParser jsonParser = new JsonParser();
        String bodyToken = "";
        try (InputStream inputStream = response.getEntity().getContent();){
            bodyToken = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
        }
        JsonObject bearerResponse = jsonParser.parse(bodyToken).getAsJsonObject();
        return bearerResponse.get("bearerToken").getAsString();
    }
}

